# -*- coding: utf-8 -*-

import os
import logging
import time

from urllib2 import urlopen
from contextlib import closing
from shutil import copyfile

from sandbox.sandboxsdk import process
from sandbox.sandboxsdk import paths

from sandbox.projects.common.search import components as sc
from sandbox.projects.common import error_handlers as eh


class MasterNewsd(sc.SearchComponent):
    name = 'master_newsd'
    http_collection = ''

    def __init__(self, binary, port, slave, state, storage, onlines, work_dir="masterd_newsd_state", debug=False):
        super(MasterNewsd, self).__init__(self)

        self.binary = binary
        self.port = port
        self.slave = slave
        self.state = state
        self.storage = storage
        self.onlines = onlines
        self.states_dir = work_dir
        self.debug = debug

    def start(self):
        paths.make_folder(self.states_dir, delete_content=True)

        tag = None
        with open(self.state+"/iter_time") as fd:
            tag = fd.read()
            tag = tag.rstrip("\n")
        eh.ensure(tag is not None, "Failed to get iter_time from state")

        state = paths.make_folder(self.states_dir+"/"+tag)
        for f in "docid2docurl", "dups-srcs.txt", "meta", "SBEADS.resC", "since.info":
            copyfile(self.state+"/"+f, state+"/"+f)

        with open(self.states_dir+"/current", "w") as current:
            current.write(tag+"\n")

        master_log = paths.get_unique_file_name(paths.get_logs_folder(), "master.log")

        cmd = [
            self.binary,
            '--slave', self.slave,
            '--storage', self.storage,
            '-l', self.states_dir,
            '-p', str(self.port),
            '-L', master_log,
        ]

        if self.onlines is not None:
            cmd.append('--online-source')
            cmd.append(self.onlines)

        if self.debug:
            cmd.append('--debug')

        self.process_parameters = cmd

        self.process = process.run_process(cmd, log_prefix='master_newsd_', wait=False)

    def wait(self, timeout=300):
        logging.info("Waiting for master_newsd to become ready for {} seconds".format(timeout))
        start = time.time()
        finish = start + timeout
        while time.time() < finish:
            if not self.is_running():
                logging.info("%s died", self.name)
                self._wait_coredump()
                self._process_post_mortem()
            try:
                with closing(urlopen('http://localhost:%d/current' % self.port)) as f:
                    reply = f.read()
                    if reply.find(':') >= 0:
                        logging.info('master_newsd is ready')
                        return
            except:
                pass
            time.sleep(1)
        if self.is_running():
            logging.info("Kill process %s", self.process.pid)
            os.kill(self.process.pid, 6)  # generate coredump
            self._wait_coredump()
        eh.check_failed("Cannot connect to {}, port {} in {} seconds".format(
            self.name, self.port, timeout
        ))

    def use_component(self, func):
        return func()

    def warmup_request(self):
        pass
