# -*- coding: utf-8 -*-

from sandbox.sdk2.legacy import SandboxParameter


def replace_parameters_default_value(params, default_values_dict):
    replace_map = {(k.name if issubclass(k, SandboxParameter) else k): v for (k, v) in default_values_dict.iteritems()}

    result = []
    for p in params:
        if p.name in replace_map:
            new_default_value = replace_map.pop(p.name)
            parameter_subclass = type(p.name, (p,), {"default_value": new_default_value})
            result.append(parameter_subclass)
        else:
            result.append(p)
    if replace_map:
        missing_parameters = sorted(replace_map.keys())
        raise Exception("Unable to find parameters: {}".format(", ".join(missing_parameters)))
    return result
