# - * - encoding: UTF-8 - * -

import hashlib
import struct


def rank_by_hostname(hostname, min_priority=None, max_priority=None, seed=None):
    if min_priority is None:
        min_priority = -100
    if max_priority is None:
        max_priority = 100

    if min_priority > max_priority:
        return 0
    elif min_priority == max_priority:
        return min_priority
    else:
        range_length = max_priority - min_priority + 1
        h = hashlib.md5(hostname)
        if seed is not None:
            h.update(seed)
        digest = h.digest()
        value, = struct.unpack_from("<I", digest)
        priority = (value % range_length) + min_priority
        return priority
