# -*- coding: utf-8 -*-

from sandbox.sandboxsdk import process

import re
import os
import shutil


def checkout(svn_url, checkout_dir):
    if os.path.exists(checkout_dir):
        shutil.rmtree(checkout_dir)
    os.makedirs(checkout_dir)
    process.run_process(['svn', 'co', svn_url, checkout_dir], log_prefix='checkout')
    return checkout_dir


def checkout_file(svn_url, checkout_dir):
    revision = None
    if re.search(r"@\d+$", svn_url):
        (svn_url, revision) = svn_url.rsplit('@')
    (svn_dir, svn_file) = svn_url.rsplit('/', 1)
    if revision:
        svn_dir = svn_dir + "@" + revision
    dir = checkout(svn_dir, checkout_dir)
    return os.path.join(dir, svn_file)
