# -*- coding: utf-8 -*-

# import os

from sandbox.projects.common.base_search_quality import basesearch_response_parser as brp
from sandbox.projects.common.noapacheupper.diff import diff_maker


class FractionProtoHrDataComparator(diff_maker.FractionDataComparator):
    def __init__(self, data_patchers, can_compare):
        super(FractionProtoHrDataComparator, self).__init__(data_patchers, can_compare)

    def data_to_node(self, data):
        node = brp._parse_single_response(data)
        self.patch(node)
        return node

    def on_has_diff(self, num, node1, node2, descr):
        super(FractionProtoHrDataComparator, self).on_has_diff(num, node1, node2, descr)
        self.sbs_info.add_diff(num, node1, node2, descr)

    def on_has_not_diff(self, num):
        super(FractionProtoHrDataComparator, self).on_has_not_diff(num)
        self.sbs_info.add_not_diff()


class DiffProtoHrResponses(diff_maker.DiffMaker):
    def __init__(self, data_patchers=[], can_compare=None):
        self.data_patchers = data_patchers
        self.can_compare = can_compare

    def create_comparator(self):
        return FractionProtoHrDataComparator(self.data_patchers, self.can_compare)
