#!/usr/bin/env python
# encoding: utf8

import six
import re
import urllib2
from collections import OrderedDict

LOCALE_UNIVERSE = "universe"


def parse_rule_name(rule_name):
    res = re.match("(-)?([A-Za-z0-9]+)(?:/([a-z]+))?", rule_name)

    if not res:
        raise Exception("Unsupported rule name: '%s'" % rule_name)

    disable, name, locale = res.groups()

    if not name:
        raise Exception("Empty rule name from rule: '%s'" % rule_name)

    return (disable and disable == '-' or None), name, (locale or LOCALE_UNIVERSE)


def parse_rearrange_options_rule_args(options):
    options = options.strip()
    input_off = 0
    input_sz = len(options)
    res = OrderedDict()

    def reset_unclosed():
        return {'[': 0, '{': 0, '"': 0, "'": 0}

    unclosed = reset_unclosed()

    def inside_string():
        return unclosed['"'] + unclosed["'"]

    def inside_json():
        return inside_string() + unclosed['['] + unclosed['{']

    json_bracks = {
        '{': ('{', 1),
        '[': ('[', 1),
        '}': ('{', -1),
        ']': ('[', -1),
    }

    while True:
        while input_off < input_sz and options[input_off] in (' ', '\t'):
            input_off += 1

        if input_off >= input_sz:
            break

        key_end = -1
        val_end = -1
        pair_end = False
        unclosed = reset_unclosed()

        i = input_off

        while i < input_sz and not pair_end:
            uc, d, bcknt = None, None, 0
            c = options[i]

            if '=' == c:
                if key_end == -1 and not inside_json():
                    key_end = i
            elif c in json_bracks:
                if not inside_string():
                    uc, d = json_bracks[c]
                    unclosed[uc] += d
            elif c in ('"', "'"):
                if not inside_string():
                    unclosed[c] = 1
                else:
                    bckcnt = 0
                    for j in six.moves.range(i - 1, -1, -1):
                        if '\\' != options[j]:
                            break
                        bcknt += 1
                    if not (bckcnt % 2):
                        unclosed[c] = 0
            elif c in (',', ';'):
                if not inside_json():
                    pair_end = True
                    if key_end == -1:
                        key_end = i
                    else:
                        val_end = i

            i += 1

        if i == input_sz:
            if key_end == -1:
                key_end = i
            elif val_end == -1:
                val_end = i

        key = options[input_off:key_end].strip()
        val = options[key_end + 1:val_end].strip() if val_end != -1 else None

        if key:
            res[key] = val

        input_off = i

    return res


CONF_NAME = "cfg"
CONF_OPTIONS = "opt"


def parse_rearrange_options(rules):
    rules = rules.strip()
    result = []
    opened = 0
    name = ""
    config = ""
    prev = 0
    rules_sz = len(rules)

    for it in six.moves.range(0, rules_sz):
        if '(' == rules[it]:
            if not opened:
                if prev != rules_sz:
                    name = rules[prev:it]
                prev = it + 1
            opened += 1
        elif ')' == rules[it]:
            opened -= 1
            if not opened and prev != rules_sz:
                config = rules[prev:it]
                prev = rules_sz
        elif rules[it] in (' ', '\t'):
            if not opened:
                if prev != rules_sz:
                    name = rules[prev:it]
                prev = rules_sz
        else:
            if not opened and name:
                rule = OrderedDict()
                rule[CONF_NAME] = name
                rule[CONF_OPTIONS] = parse_rearrange_options_rule_args(config)
                result.append(rule)

                prev = it
                name = ""
                config = ""

    if prev != rules_sz:
        name = rules[prev:rules_sz]

    if name:
        rule = OrderedDict()
        rule[CONF_NAME] = name
        rule[CONF_OPTIONS] = parse_rearrange_options_rule_args(config)
        result.append(rule)

    return result


def get_rearranges(ep='localhost:9080'):
    f = urllib2.urlopen('http://{}/yandsearch?info=rearrange_options'.format(ep))
    d = f.read()
    f.close()
    rearrs = set()
    for r in parse_rearrange_options(d):
        rearr = r.get(CONF_NAME, None)
        if rearr and rearr[0] != '/':
            rearrs.add(rearr.split('/')[0])
    return rearrs

# print get_rearranges()
