# -*- coding: utf-8 -*-
# WARNING: file for use outside sandbox! so not import sandbox include dependency

from __future__ import print_function

import json
import urllib
import urlparse


class Error(Exception):
    def __init__(self, err):
        self.error = err

    def __str__(self):
        return self.error


CGI = 0
YA_MULTI_JSON = 1
APP_UPPER = 2


# keep local copy parse_cgi_params for avoid mongoengine dependency from utils.py
def parse_cgi_params(str, unquote=True):
    res = {}

    for key_and_value in str.split('&'):
        if not key_and_value:
            continue
        parts = key_and_value.split('=', 1)

        if len(parts) < 2:
            key, value = parts[0], ''
        else:
            key, value = parts
            value = urllib.unquote(value) if unquote else value

        res[key] = res.get(key, []) + [value]

    return res


class Request:
    """
        parse/serialize/debug_print request to noapache
        (format with client_ctx + global_ctx, also support pre-apphost json format)
    """

    def __init__(self, s=None):
        self.clear()
        if s:
            if '\t' in s:
                # has json request (SERP-35156, SEARCH-1620)
                self.format = YA_MULTI_JSON
                self.raw_ctx = []
                params = s.split('\n')
                for param in params:
                    if not param:
                        continue  # skip empty lines
                    tk = param.rstrip('\n').split('\t')
                    p = tk[0]
                    if p == 'global_ctx':
                        self.global_ctx = json.loads(tk[1])
                    elif p == 'client_ctx':
                        self.client_ctx = json.loads(tk[1])
                    elif p == 'raw_ctx':
                        self.raw_ctx.append([json.loads(tk[1]), json.loads(tk[2])])
                    else:
                        raise Exception('unknown json req param: {}\nrequest:{}'.format(param, s))
            elif s.startswith('{'):
                # has app_host format (SEARCH-1493)
                self.format = APP_UPPER
                self._parse_app_req(s)
            else:
                self.format = CGI
                if s.startswith('/'):
                    # has url-path + cgi params
                    self.purl = urlparse.urlparse(s)
                    self._parse_query(self.purl.query)
                else:
                    # has only cgi params
                    self._parse_query(s)
                    self.purl = ('', '', '', '', '', '')

    def clear(self):
        self.format = None
        self.purl = None
        self.global_ctx = None
        self.client_ctx = None
        self.raw_ctx = None

    def add_global_ctx_cgi_params(self, params):
        if not self.global_ctx:
            raise Error('shit happens')
        qparams = parse_cgi_params(params)
        for k, lv in qparams.iteritems():
            for v in lv:
                self.add_global_ctx_param(k, v)
        return self

    def add_global_ctx_param(self, name, value):
        if not self.global_ctx:
            raise Error('shit happens')
        self.global_ctx.setdefault(name, []).append(value)
        return self

    def add_global_ctx_json(self, jval):
        if self.global_ctx is None:
            self.global_ctx = {}
        for k, v in json.loads(jval).iteritems():
            self.global_ctx[k] = v

    def add_client_ctx_json(self, jval):
        if self.client_ctx is None:
            self.client_ctx = {}
        for k, v in json.loads(jval).iteritems():
            self.client_ctx[k] = v

    def serialize(self, format=None):
        if format is None:
            format = self.format
        if format == CGI:
            return self.serialize_cgi()
        elif format == YA_MULTI_JSON:
            return self.serialize_ya_multi_json()
        elif format == APP_UPPER:
            return self.serialize_app_upper()
        else:
            raise Exception('can not serialize unknown noapache request')

    def serialize_cgi(self):
        params = []  # use array for ensure global_ctx become last param like original
        if self.client_ctx:
            params.append(('client_ctx', json.dumps(self.client_ctx)))
        if self.raw_ctx:
            for r in self.raw_ctx:
                params.append(('raw_ctx', urllib.urlencode(r, doseq=True)))
        if self.global_ctx:
            params.append(('global_ctx', urllib.urlencode(self.global_ctx, doseq=True)))
        query = urllib.urlencode(params)
        return urlparse.urlunparse((
            self.purl[0], self.purl[1], self.purl[2], self.purl[3], query, self.purl[5]
        )).lstrip('?')

    def serialize_ya_multi_json(self):
        r = ''
        r += 'global_ctx\t{}'.format(json.dumps(self.global_ctx))
        if self.client_ctx:
            r += '\nclient_ctx\t{}'.format(json.dumps(self.client_ctx))
        if self.raw_ctx:
            for rc in self.raw_ctx:
                r += '\nraw_ctx\t{}\t{}'.format(json.dumps(rc[0]), json.dumps(rc[1]))
        return r

    def print_tree(self):  # for debug purpose
        def print_sorted_dict(d, prefix='\t'):
            for k in sorted(d.keys()):
                print('{}{}: {}'.format(prefix, k, d[k]))

        def print_recursive_sorted_dict(d, prefix='\t'):
            for k in sorted(d.keys()):
                if isinstance(d[k], dict):
                    print('{}{}:'.format(prefix, k))
                    print_recursive_sorted_dict(d[k], prefix + '\t')
                else:
                    print('{}{}: {}'.format(prefix, k, d[k]))

        if self.global_ctx:
            print('global_ctx:')
            print_sorted_dict(self.global_ctx)
        if self.raw_ctx:
            for r in self.raw_ctx:
                print('raw_ctx:')
                if isinstance(r, dict):
                    print_recursive_sorted_dict(r)
                else:
                    print_recursive_sorted_dict(r[0])
                    print_recursive_sorted_dict(r[1])
        if self.client_ctx:
            print('client_ctx:')
            for cname in sorted(self.client_ctx.keys()):
                print('\t{}:'.format(cname))
                print_sorted_dict(self.client_ctx[cname], '\t\t')

    def _parse_query(self, s):
        qparams = parse_cgi_params(s)
        tmp = qparams.get('global_ctx', None)
        if tmp:
            if len(tmp) > 1:
                raise Error('multiple global_ctx params')
            self.global_ctx = parse_cgi_params(tmp[0])
        tmp = qparams.get('client_ctx', None)
        if tmp:
            if len(tmp) > 1:
                raise Error('multiple client_ctx params')
            self.client_ctx = json.loads(tmp[0])
        tmp = qparams.get('raw_ctx', None)
        if tmp:
            self.raw_ctx = []
            for r in tmp:
                self.raw_ctx.append(parse_cgi_params(r))

    def _parse_app_req(self, s):
        req = json.loads(s)
        for k, v in req.iteritems():
            if k == 'global_ctx':
                self.global_ctx = v
            elif k == 'client_ctx':
                self.client_ctx = v

    def serialize_app_upper(self):
        r = {}
        if self.global_ctx:
            r['global_ctx'] = self.global_ctx
        if self.client_ctx:
            r['client_ctx'] = self.client_ctx
        return json.dumps(r)
