# -*- coding: utf-8 -*-

import os
import multiprocessing
import functools
import sandbox.projects.common.app_host.converter as apphost_converter
from sandbox.projects.common.noapacheupper.diff.diff_maker import data_iterator


def responses_to_json_iterator(
    data_filename,
    index_filename,
    recs_begin,
    recs_limit,
    apphost_converter_path,
):
    return multiprocessing.Pool(None).imap(
        functools.partial(
            apphost_converter.convert_input_response,
            apphost_converter_path,
            plain_text=True
        ),
        data_iterator(
            data_filename,
            index_filename,
            recs_begin,
            recs_limit,
        ),
    )


def _do_unpack(args):
    with open(os.path.join(args[0], 'response_{}.json'.format(args[1])), 'w') as out:
        out.write(args[2].strip())


def unpack_to_files(
    data_filename,
    index_filename,
    recs_begin,
    recs_limit,
    apphost_converter_path,
    output_directory,
):
    pool = multiprocessing.Pool(None)
    pool.imap(
        _do_unpack,
        (
            (output_directory, i, json_string) for i, json_string in enumerate(
                responses_to_json_iterator(
                    data_filename,
                    index_filename,
                    recs_begin,
                    recs_limit,
                    apphost_converter_path,
                )
            )
        )
    )
    pool.close()
    pool.join()
