import pytest

from sandbox.projects.common import paths


@pytest.mark.parametrize(
    "sub_path, path, expected",
    [
        ("qq/pp", "qq/pp", True),
        ("qq/pp", "qq/pp/sss", True),
        ("qq/pp", "qq/pp/sss.txt", True),
        ("qq/pp.txt", "qq/pp.txt", True),
        ("qq/pp", "qq/ppsss", False),
        ("qq/pp", "/qq/pp", False),
    ]
)
def test_is_sub_path_of(sub_path, path, expected):
    result = paths.is_sub_path_of(sub_path, path)
    assert result == expected
