# -*- coding: utf-8 -*-

"""
DEPRECATED. See comments in
https://rb.yandex-team.ru/arc/r/206164/
Should be removed after Q4-2016
"""

import copy
import json
import logging
import math

import sandbox.common.types.client as ctc
from sandbox.sandboxsdk.channel import channel
from sandbox.sandboxsdk import parameters
from sandbox.sandboxsdk import sandboxapi
from sandbox.sandboxsdk import task

from sandbox.projects.common import apihelpers
from sandbox.projects.common import cms
from sandbox.projects.common import dolbilka
from sandbox.projects.common import error_handlers as eh
from sandbox.projects.common import utils
from sandbox.projects.common.search.database import iss_shards
from sandbox.projects.common.search import settings as media_settings
from sandbox.projects.common.search import components as search_components
from sandbox.projects.common.search import BaseTestSuperMindTask as supermind_task

from sandbox.projects.common import BaseGetDatabaseTask
from sandbox.projects.common import decorators

from sandbox.projects.VideoTestBasesearchPerformance import PlanParameter
from sandbox.projects.GenerateAllPlans import GenerateAllPlans
from sandbox.projects.GenerateAllPlans import PlanGenParams

import xmlrpclib


_BASESEARCH_SHARD_KEY = '{}_basesearch_database_shards'
_MIDDLESEARCH_SHARD_KEY = '{}_middlesearch_database_shard'
_SHARD_TASKS = 'shard_tasks'
_PLAN_TASKS = 'plan_tasks'
_PERFORMANCE_TASKS = 'performance_tasks'
_PERFORMANCE_STATS = 'performance_stats'
_ANALYZE_TASKS = 'analyze_tasks'
_ANALYZE_RESULTS = 'analyze_results'

_PLAN_GENERATOR_GROUP = 'Plan generation options'
_DATABASE_SHARDS_GROUP = 'Database shards'


class ForceLoadBasesearchDatabaseParameter(parameters.SandboxBoolParameter):
    name = 'force_load_basesearch_database'
    description = 'Force basesearch database load'
    default_value = False


class ForceLoadMiddlesearchDatabaseParameter(parameters.SandboxBoolParameter):
    name = 'force_load_middlesearch_database'
    description = 'Force middlesearch database load'
    default_value = False


class ShardsCountParameter(parameters.SandboxIntegerParameter):
    name = 'shards_count'
    description = 'Number of shards'
    default_value = 1


class RequestsNumberParameter(parameters.SandboxIntegerParameter):
    group = _PLAN_GENERATOR_GROUP
    name = 'requests_number'
    description = 'Mmeta request count'
    default_value = 100000


class DisableCacheParameter(parameters.SandboxBoolParameter):
    group = _PLAN_GENERATOR_GROUP
    name = 'disable_cache'
    description = 'Disable mmeta cache'
    default_value = False


class OldMmetaShardParameter(parameters.SandboxStringParameter):
    group = _DATABASE_SHARDS_GROUP
    name = _MIDDLESEARCH_SHARD_KEY.format('old')
    description = 'Old mmeta shard'
    default_value = False


class NewMmetaShardParameter(parameters.SandboxStringParameter):
    group = _DATABASE_SHARDS_GROUP
    name = _MIDDLESEARCH_SHARD_KEY.format('new')
    description = 'New mmeta shard'
    default_value = False


class OldBaseShardParameter(parameters.SandboxStringParameter):
    group = _DATABASE_SHARDS_GROUP
    name = _BASESEARCH_SHARD_KEY.format('old')
    description = 'Old base shards (comma separated)'
    default_value = False


class NewBaseShardParameter(parameters.SandboxStringParameter):
    group = _DATABASE_SHARDS_GROUP
    name = _BASESEARCH_SHARD_KEY.format('new')
    description = 'New base shards (comma separated)'
    default_value = False


class UseRbtorrentTransportParameter(parameters.SandboxBoolParameter):
    name = 'use_rbtorrent_transport'
    description = 'Use rbtorrent transport'
    default_value = False


class BasePriemkaDatabaseTask(task.SandboxTask):

    input_parameters = (
        ForceLoadBasesearchDatabaseParameter,
        ForceLoadMiddlesearchDatabaseParameter,
        ShardsCountParameter,
        DisableCacheParameter,
        RequestsNumberParameter,
        OldMmetaShardParameter,
        NewMmetaShardParameter,
        OldBaseShardParameter,
        NewBaseShardParameter,
        UseRbtorrentTransportParameter,
    )

    _OLD_AGE = 'old'
    _NEW_AGE = 'new'
    _ALL_AGES = (_OLD_AGE, _NEW_AGE)

    __TOTAL_STATS = ("avg", "stddev")
    __SHARD_STATS = (
        ("median", "shooting.rps_0.5"),
        ("stddev", "shooting.rps_stddev"),
        ("errors", "shooting.errors"),
    )

    __SHARD_HEADER_TEMPLATE = [
        "<span style='color:gray'>Shard</span>",
        "<span style='color:gray'>Performance</span>",
        "<span style='color:gray'>Max rps</span>",
        "<span style='color:gray'>Median rps</span>",
        "<span style='color:gray'>Queries</span>",
    ]

    __DIFF_HEADER_TEMPLATE = [
        "Diff max",
        "Diff avg-all",
        "Diff median",
        "Diff queries",
    ]

    client_tags = ctc.Tag.LINUX_PRECISE

    ###
    def _get_tests(self):
        raise NotImplementedError()

    def _get_analyzes(self):
        return []

    ###
    def _get_basesearch_database_tag(self, age):
        raise NotImplementedError()

    def _get_basesearch_database_task(self):
        raise NotImplementedError()

    def _get_basesearch_database_resource(self):
        raise NotImplementedError()

    def _get_basesearch_database_execution_space(self):
        return None

    def _get_basesearch_executable(self, age):
        return self.ctx.get('{}_basesearch_executable_resource_id'.format(age))

    def _get_basesearch_config(self, age):
        return self.ctx.get('{}_basesearch_config_resource_id'.format(age))

    def _get_basesearch_plan(self):
        return None

    def _get_basesearch_performance_task(self):
        raise NotImplementedError()

    def _get_basesearch_performance_args(self, query_type):
        return {}

    def _get_basesearch_models(self):
        return None

    def _get_basesearch_analyze_task(self):
        raise NotImplementedError()

    def _get_basesearch_analyze_args(self, query_type):
        return {}

    def _get_middlesearch_database_task(self):
        raise NotImplementedError()

    def _get_middlesearch_database_resource(self):
        raise NotImplementedError()

    def _get_stable_middlesearch_shard(self):
        raise NotImplementedError()

    def _get_middlesearch_executable(self, age):
        return self.ctx.get('{}_middlesearch_executable_resource_id'.format(age))

    def _get_middlesearch_config(self, age):
        raise NotImplementedError()

    def _get_middlesearch_data(self, age):
        raise NotImplementedError()

    def _get_middlesearch_plan(self):
        raise NotImplementedError()

    def _get_middlesearch_models(self):
        return None

    def _get_basesearch_queries_custom_params(self, age):
        return ''

    def _get_gen_search_plan(self):
        return True

    def _get_gen_factors_plan(self):
        return False

    def _get_gen_snippets_plan(self):
        return True

    def on_execute(self):
        shards_count = int(self.ctx[ShardsCountParameter.name])
        self.ctx[ShardsCountParameter.name] = shards_count

        for age in self._ALL_AGES:
            if not self.ctx[_BASESEARCH_SHARD_KEY.format(age)]:
                cms_configuration, instance_tag_name = self._get_basesearch_database_tag(age)
                basesearch_shard_names = cms.get_cms_shards(instance_tag_name, cms_configuration)
                self.ctx[_BASESEARCH_SHARD_KEY.format(age)] = ','.join(basesearch_shard_names[:shards_count])
            if not self.ctx[_MIDDLESEARCH_SHARD_KEY.format(age)]:
                logging.info('searching for the latest stable mmeta database...')
                self.ctx[_MIDDLESEARCH_SHARD_KEY.format(age)] = self._get_stable_middlesearch_shard()

        if _SHARD_TASKS not in self.ctx:
            results = {}
            for age in self._ALL_AGES:
                mmeta_shard_name = self.ctx[_MIDDLESEARCH_SHARD_KEY.format(age)]
                results[','.join((mmeta_shard_name, age))] = self._middlesearch_database_subtask(
                    mmeta_shard_name, age)
                for base_shard_name in self.__get_basesearch_shards(age):
                    results[','.join((base_shard_name, age))] = self._basesearch_database_subtask(
                        base_shard_name, age)
            self.ctx[_SHARD_TASKS] = results

        if not self._get_basesearch_plan() and _PLAN_TASKS not in self.ctx:
            results = {}
            for age in self._ALL_AGES:
                mmeta_shard_name = self.ctx[_MIDDLESEARCH_SHARD_KEY.format(age)]
                for base_shard_name in self.__get_basesearch_shards(age):
                    results[','.join((mmeta_shard_name, base_shard_name, age))] = self._middlesearch_plan_subtask(
                        mmeta_shard_name, base_shard_name, age)
            self.ctx[_PLAN_TASKS] = results

        if _PERFORMANCE_TASKS not in self.ctx:
            results = {}
            for supermind_mult, query_type in self._get_tests():
                supermind_str = str(supermind_mult) if supermind_mult else 'none'
                for age in self._ALL_AGES:
                    mmeta_shard_name = self.ctx[_MIDDLESEARCH_SHARD_KEY.format(age)]
                    for base_shard_name in self.__get_basesearch_shards(age):
                        key = ','.join((mmeta_shard_name, base_shard_name, supermind_str, query_type, age))
                        results[key] = self._basesearch_performance_subtask(
                            mmeta_shard_name, base_shard_name, supermind_mult, query_type, age)
            self.ctx[_PERFORMANCE_TASKS] = results

        if _ANALYZE_TASKS not in self.ctx:
            results = {}

            def _append_analyze_task(*args):
                results[_make_ctx_key(*args)] = self._basesearch_analyze_subtask(*args)

            for supermind_mult, query_type in self._get_analyzes():
                self._basesearch_analyze_foreach(supermind_mult, query_type, _append_analyze_task)

            self.ctx[_ANALYZE_TASKS] = results

        self._sync_subtasks()

        # Results in context are used outside as well (like in images auto-acceptance)
        self.ctx[_ANALYZE_RESULTS] = list(self._get_analyze_results())
        self.ctx[_PERFORMANCE_STATS] = self._collect_performance_stats()

    @property
    def footer(self):
        items = []
        items.extend(self._get_performance_footer())
        items.extend(self._get_analyze_footer())

        return [{"content": item} for item in items]

    def _get_performance_footer(self):
        if not self._get_tests():
            return []

        header_template = \
            ["Old"] + \
            self.__SHARD_HEADER_TEMPLATE + \
            ["New"] + \
            self.__SHARD_HEADER_TEMPLATE + \
            self.__DIFF_HEADER_TEMPLATE

        def render_shard(shards, age):
            return [
                "<a style='white-space: nowrap' href='/resource/{}/view'>{}</a>".format(
                    s["{}-shard-resource".format(age)], s["{}-shard-name".format(age)])
                for s in shards
            ]

        def render_task(shards, age):
            return [
                "<a href='/task/{}/view'>{}</a>".format(
                    s["{}-perf-task-id".format(age)], s["{}-perf-task-status".format(age)])
                for s in shards
            ]

        def render_rps(result, age, variant):
            return [
                "{:0.2f}".format(s["{}-perf-{}-rps".format(age, variant)])
                for s in result["shards"]
            ] + [
                "<strong>{:0.2f}</strong>".format(result["{}-{}-perf-{}-rps".format(age, stat, variant)])
                for stat in self.__TOTAL_STATS
            ]

        def render_queries(result, age):
            return [
                "{:0.2f}".format(s["{}-plan-queries".format(age)])
                for s in result["shards"]
            ] + [
                "<strong>{:0.2f}</strong>".format(result["{}-{}-plan-queries".format(age, stat)])
                for stat in self.__TOTAL_STATS
            ]

        def render_diff_stats(result, variant):
            return [
                "<strong>{:0.2f}%</strong>".format(result["diff-{}-perf-{}-rps".format(stat, variant)])
                for stat in self.__TOTAL_STATS
            ]

        results = self._get_performance_results()
        if not results:
            return [{"content": {"&nbsp;": [{"&nbsp;": "Calculating..."}]}}]

        items = []
        for test, result in results.iteritems():

            shards = result["shards"]
            total_stats_title = ["<strong>Average</strong>", "<strong>Stddev</strong>"]

            columns = [
                ["" for shard in shards] + total_stats_title,

                render_shard(shards, "old"),
                render_task(shards, "old"),
                render_rps(result, "old", "max"),
                render_rps(result, "old", "med"),
                render_queries(result, "old"),

                [""],

                render_shard(shards, "new"),
                render_task(shards, "new"),
                render_rps(result, "new", "max"),
                render_rps(result, "new", "med"),
                render_queries(result, "new"),

                ["{:0.2f}%".format(s["diff-perf-max-rps"]) for s in shards] + render_diff_stats(result, "max"),
                ["{:0.2f}%".format(s["diff-perf-avg-all-rps"]) for s in shards] + render_diff_stats(result, "avg-all"),
                ["{:0.2f}%".format(s["diff-perf-med-rps"]) for s in shards] + render_diff_stats(result, "med"),
                ["{:0.2f}%".format(s["diff-plan-queries"]) for s in shards] +
                ["<strong>{:0.2f}%</strong>".format(result["diff-{}-plan-queries".format(stat)]) for stat in self.__TOTAL_STATS]
            ]
            assert len(columns) == len(header_template)

            table = "<h4>Test, supermind_mult={0}, query_type={1}</h4>".format(*test)
            items.append({
                table: {
                    "header": [
                        {"key": "k{}".format(i), "title": title}
                        for i, title in enumerate(header_template)
                    ],
                    "body": {
                        "k{}".format(i): column
                        for i, column in enumerate(columns)
                    },
                }
            })

        return items

    def _get_performance_results(self):
        if _PERFORMANCE_STATS not in self.ctx:
            return {}

        output = {}
        for k, shards in self.ctx[_PERFORMANCE_STATS].iteritems():
            output_shards = [copy.deepcopy(pair[1]) for pair in sorted(shards.iteritems(), key=lambda pair: pair[0])]

            stats = {
                'shards': output_shards,
            }
            for key in ('perf-max-rps', 'perf-med-rps', 'perf-avg-all-rps', 'plan-queries'):
                for shard in output_shards:
                    shard['diff-{}'.format(key)] = self.__delta_percent(shard['old-{}'.format(key)],
                                                                        shard['new-{}'.format(key)])

                old_lst = [v['old-{}'.format(key)] for v in output_shards]
                new_lst = [v['new-{}'.format(key)] for v in output_shards]

                old_avg = self.__average(old_lst)
                new_avg = self.__average(new_lst)

                old_stddev = self.__stddev(old_lst)
                new_stddev = self.__stddev(new_lst)

                stats.update({
                    'old-avg-{}'.format(key): old_avg,
                    'new-avg-{}'.format(key): new_avg,
                    'old-stddev-{}'.format(key): old_stddev,
                    'new-stddev-{}'.format(key): new_stddev,
                    'diff-avg-{}'.format(key): self.__delta_percent(old_avg, new_avg),
                    'diff-stddev-{}'.format(key): self.__delta_percent(old_stddev, new_stddev),
                })
            output[tuple(k.split(','))] = stats

        return output

    def _collect_performance_stats(self):
        stats = {}

        # join stats from old and new shards
        for key, performance_task_id in self.ctx[_PERFORMANCE_TASKS].iteritems():
            mmeta_shard_name, base_shard_name, supermind_mult, query_type, age = key.split(',')
            shard_prefix, shard_number, ts1, ts2 = base_shard_name.split('-')

            base_shard_data = self.ctx[_SHARD_TASKS][','.join((base_shard_name, age))]

            performance_task = channel.sandbox.get_task(performance_task_id)
            performance_max_rps = max(performance_task.ctx.get('requests_per_sec', [0]))
            performance_avg_all_rps = performance_task.ctx.get('requests_avg_all')
            performance_med_rps = self.__median_rps(performance_task.ctx.get('requests_per_sec_2d', [[]]))

            database_task_id = base_shard_data['shard-task']
            database_task = channel.sandbox.get_task(database_task_id)

            if not self._get_basesearch_plan():
                base_plan_data = self.ctx[_PLAN_TASKS][','.join((mmeta_shard_name, base_shard_name, age))]
                plan_task_id = base_plan_data['plan-task']
                plan_task = channel.sandbox.get_task(plan_task_id)
                plan_queries = plan_task.ctx.get('stats', {}).get(query_type, {}).get('queries_amount', 0)
            else:
                plan_queries = 0

            stats.setdefault(','.join((supermind_mult, query_type)), {}).setdefault(shard_number, {}).update({
                '{}-shard-name'.format(age): base_shard_name,
                '{}-shard-resource'.format(age): base_shard_data['shard-resource'],
                '{}-shard-task-id'.format(age): database_task_id,
                '{}-shard-task-status'.format(age): database_task.new_status,
                '{}-perf-task-id'.format(age): performance_task_id,
                '{}-perf-task-status'.format(age): performance_task.new_status,
                '{}-perf-max-rps'.format(age): performance_max_rps,
                '{}-perf-avg-all-rps'.format(age): performance_avg_all_rps,
                '{}-perf-med-rps'.format(age): performance_med_rps,
                '{}-plan-queries'.format(age): plan_queries,
            })

        return stats

    def _get_analyze_results(self):
        for supermind_mult, query_type in self._get_analyzes():
            results = []

            def _append_analyze_results(*args):
                task_id = self.ctx[_ANALYZE_TASKS][_make_ctx_key(*args)]

                (old_mmeta_shard_name, new_mmeta_shard_name,
                 old_base_shard_name, new_base_shard_name,
                 supermind_mult, query_type) = args

                data = {
                    "old_shard": old_base_shard_name,
                    "new_shard": new_base_shard_name,
                    "task": task_id
                }
                data.update(self._basesearch_analyze_results(task_id))
                results.append(data)

            self._basesearch_analyze_foreach(supermind_mult, query_type, _append_analyze_results)

            # total stats
            import numpy

            avg_result = {"title": "Avg"}
            for stat, _ in self.__SHARD_STATS:
                if all(stat in v for v in results):
                    avg_result[stat] = float(numpy.average([v[stat] for v in results]))
            results.append(avg_result)
            yield (supermind_mult, query_type, results)

    def _get_analyze_footer(self):
        if not self._get_analyzes():
            return []

        if _ANALYZE_TASKS not in self.ctx:
            return [{"content": {"&nbsp;": [{"&nbsp;": "Calculating..."}]}}]

        items = []

        for supermind_mult, query_type, results in self._get_analyze_results():
            def _format(fmt, value, default=""):
                return fmt.format(value) if value is not None else default

            title = "<h4>New test, supermind_mult={0}, query_type={1}</h4>".format(supermind_mult, query_type)
            items.append({
                title: {
                    "header": [
                        {"key": "task",   "title": "Task"},
                        {"key": "old_shard",   "title": "Old shard"},
                        {"key": "new_shard",   "title": "New shard"},
                        {"key": "median", "title": "Median RPS"},
                        {"key": "stddev", "title": "Standard deviation"},
                        {"key": "errors", "title": "Errors"},
                    ],
                    "body": {
                        "task": [_format("<a href='/task/{0}/view'>{0}</a>", v.get("task"), v.get("title")) for v in results],
                        "old_shard": [v.get("old_shard", "") for v in results],
                        "new_shard": [v.get("new_shard", "") for v in results],
                        "median": [_format("{:0.2f}%", v.get("median")) for v in results],
                        "stddev": [_format("{:0.2f}%", v.get("stddev")) for v in results],
                        "errors": [_format("{}%", v.get("errors")) for v in results],
                    },
                }
            })

        return items

    def _get_cms_shard_name(self, shard_name):
        try:
            return self._try_cms_shard_name(shard_name)
        except Exception as e:
            logging.info("Problem during search in CMS: {}".format(e))
            return None

    @decorators.retries(3, 1)
    def _try_cms_shard_name(self, shard_name):
        logging.info("Trying CMS...")
        try:
            cms_proxy = xmlrpclib.ServerProxy('http://cmsearch.yandex.ru/xmlrpc/bs')
            return cms_proxy.getShard(shard_name)['resource_url']
        except xmlrpclib.Fault:
            return None

    def _database_subtask(self, task_type, resource_type, shard_name, age, force, execution_space=None):
        if not force:
            database_resource = apihelpers.get_last_resource_with_attribute(
                resource_type,
                media_settings.SHARD_INSTANCE_ATTRIBUTE_NAME,
                shard_name
            )
            if database_resource:
                return {
                    'shard-task': database_resource.task_id,
                    'shard-resource': database_resource.id,
                }

        logging.info('Getting database, shard {}'.format(shard_name))
        shard_attributes = '{}={}'.format(media_settings.SHARD_INSTANCE_ATTRIBUTE_NAME, shard_name)

        sub_ctx = {
            BaseGetDatabaseTask.DatabaseShardName.name: shard_name,
            BaseGetDatabaseTask.DatabaseAttr.name: shard_attributes,
            BaseGetDatabaseTask.BackupDatabaseResource.name: True,
        }

        if self.ctx[UseRbtorrentTransportParameter.name]:
            shard_location = iss_shards.get_shard_name(shard_name) or self._get_cms_shard_name(shard_name)
            eh.ensure(shard_location, "Failed to find shard {} in registry".format(shard_name))

            logging.info("Shard {} location is {}", shard_name, shard_location)

            sub_ctx.update({
                BaseGetDatabaseTask.DatabaseRsyncPath.name: shard_location,
                BaseGetDatabaseTask.CheckDbState.name: False,
            })

        sub_task = self.create_subtask(
            task_type=task_type,
            description='Shard, name={}, age={}'.format(shard_name, age),
            input_parameters=sub_ctx,
            execution_space=execution_space,
        )
        return {
            'shard-task': sub_task.id,
            'shard-resource': int(sub_task.ctx[BaseGetDatabaseTask.SEARCH_DATABASE_RESOURCE_ID]),
        }

    def _middlesearch_database_subtask(self, shard_name, age):
        return self._database_subtask(self._get_middlesearch_database_task(),
                                      self._get_middlesearch_database_resource(),
                                      shard_name,
                                      age,
                                      self.ctx[ForceLoadMiddlesearchDatabaseParameter.name])

    def _basesearch_database_subtask(self, shard_name, age):
        return self._database_subtask(self._get_basesearch_database_task(),
                                      self._get_basesearch_database_resource(),
                                      shard_name,
                                      age,
                                      self.ctx[ForceLoadBasesearchDatabaseParameter.name],
                                      self._get_basesearch_database_execution_space())

    def _basesearch_performance_subtask(self, mmeta_shard_name, base_shard_name, supermind_mult, query_type, age):
        logging.info('Processing shard {}'.format(base_shard_name))

        base_shard_data = self.ctx[_SHARD_TASKS][','.join((base_shard_name, age))]

        base_plan_id = self._get_basesearch_plan()
        if not base_plan_id:
            base_plan_data = self.ctx[_PLAN_TASKS][','.join((mmeta_shard_name, base_shard_name, age))]
            base_plan_id = base_plan_data['plan-{}-resource'.format(query_type)]

        sub_ctx = {
            search_components.DefaultBasesearchParams.Binary.name: self._get_basesearch_executable(age),
            search_components.DefaultBasesearchParams.Config.name: self._get_basesearch_config(age),
            search_components.DefaultBasesearchParams.Database.name: base_shard_data['shard-resource'],
            search_components.DefaultBasesearchParams.ArchiveModel.name: self._get_basesearch_models(),
            search_components.DefaultBasesearchParams.StartTimeout.name: 1800,

            PlanParameter.name: base_plan_id,

            dolbilka.DolbilkaExecutorRequestsLimit.name: 50000,
            dolbilka.DolbilkaExecutorMode.name: 'finger',
            dolbilka.DolbilkaMaximumSimultaneousRequests.name: 21,
            dolbilka.DolbilkaSessionsCount.name: 10,
        }
        sub_ctx.update(self._get_basesearch_performance_args(query_type))

        if supermind_mult is not None:
            sub_ctx.update({
                supermind_task.EnableSuperMindParameter.name: True,
                supermind_task.SuperMindModeParameter.name: 'mind',
                supermind_task.MultParameter.name: supermind_mult,
            })

        sub_task = self.create_subtask(
            task_type=self._get_basesearch_performance_task(),
            description='{}, shard={}, mult={}, query_type={}, age={}'.format(self.descr,
                                                                              base_shard_name,
                                                                              supermind_mult,
                                                                              query_type,
                                                                              age),
            input_parameters=sub_ctx,
            arch=sandboxapi.ARCH_LINUX
        )
        return sub_task.id

    def _basesearch_analyze_foreach(self, supermind_mult, query_type, func):
        """Cycle over shards for tests"""

        basesearch_shards = (
            self.__get_basesearch_shards(self._OLD_AGE),
            self.__get_basesearch_shards(self._NEW_AGE),
        )
        old_mmeta_shard_name = self.ctx[_MIDDLESEARCH_SHARD_KEY.format(self._OLD_AGE)]
        new_mmeta_shard_name = self.ctx[_MIDDLESEARCH_SHARD_KEY.format(self._NEW_AGE)]

        for old_base_shard_name, new_base_shard_name in zip(*basesearch_shards):
            func(old_mmeta_shard_name, new_mmeta_shard_name,
                 old_base_shard_name, new_base_shard_name,
                 supermind_mult, query_type)

    def _basesearch_analyze_subtask(self, old_mmeta_shard_name, new_mmeta_shard_name,
                                    old_base_shard_name, new_base_shard_name,
                                    supermind_mult, query_type):
        logging.info('Analyzing shards {}:{} vs {}:{}'.format(old_mmeta_shard_name, old_base_shard_name,
                                                              new_mmeta_shard_name, new_base_shard_name))

        task_type, basesearch_params, plan_params = self._get_basesearch_analyze_task()
        shard_names = (
            (old_mmeta_shard_name, old_base_shard_name),
            (new_mmeta_shard_name, new_base_shard_name),
        )
        age_names = (
            self._OLD_AGE,
            self._NEW_AGE,
        )

        sub_ctx = self._get_basesearch_analyze_args(query_type)
        if supermind_mult is not None:
            sub_ctx.update({
                supermind_task.EnableSuperMindParameter.name: True,
                supermind_task.SuperMindModeParameter.name: 'mind',
                supermind_task.MultParameter.name: supermind_mult
            })

        for basesearch_param, plan_param, shard, age in zip(basesearch_params, plan_params, shard_names, age_names):
            mmeta_shard_name, base_shard_name = shard
            base_shard_data = self.ctx[_SHARD_TASKS][','.join((base_shard_name, age))]
            base_plan_id = self._get_basesearch_plan()
            if not base_plan_id:
                base_plan_data = self.ctx[_PLAN_TASKS][','.join((mmeta_shard_name, base_shard_name, age))]
                base_plan_id = base_plan_data['plan-{}-resource'.format(query_type)]

            sub_ctx.update({
                basesearch_param.Binary.name: self._get_basesearch_executable(age),
                basesearch_param.Config.name: self._get_basesearch_config(age),
                basesearch_param.Database.name: base_shard_data['shard-resource'],
                basesearch_param.ArchiveModel.name: self._get_basesearch_models(),
                basesearch_param.StartTimeout.name: 1800,
                plan_param.name: base_plan_id,
            })

        sub_task = self.create_subtask(
            task_type=task_type,
            input_parameters=sub_ctx,
            description='{}, shards={}:{}, mult={}, query_type={}'.format(
                self.descr,
                old_base_shard_name,
                new_base_shard_name,
                supermind_mult,
                query_type
            ),
            arch=sandboxapi.ARCH_LINUX,
            model='E5-2650'
        )
        return sub_task.id

    def _basesearch_analyze_results(self, task_id):
        task = channel.sandbox.get_task(task_id)
        # see SPI-23859
        if 'new_stats_json' in task.ctx:
            task_stats = json.loads(task.ctx['new_stats_json']).get('diff', {})
        else:
            task_stats = task.ctx.get('new_stats', {}).get('diff', {})

        stats = {}  # Convert new names to old one
        for old_name, new_name in self.__SHARD_STATS:
            if new_name in task_stats:
                stats[old_name] = task_stats[new_name]
        return stats

    def _middlesearch_plan_subtask(self, mmeta_shard_name, base_shard_name, age):
        logging.info('Generating plan for base_shard={}, mmeta_shard={}'.format(base_shard_name, mmeta_shard_name))

        mmeta_shard_data = self.ctx[_SHARD_TASKS][','.join((mmeta_shard_name, age))]
        base_shard_data = self.ctx[_SHARD_TASKS][','.join((base_shard_name, age))]

        sub_ctx = {
            PlanGenParams.GenSearchPlan.name: self._get_gen_search_plan(),
            PlanGenParams.GenSnippetsPlan.name: self._get_gen_snippets_plan(),
            PlanGenParams.GenFactorsPlan.name: self._get_gen_factors_plan(),

            PlanGenParams.MiddleExe.name: self._get_middlesearch_executable(age),
            PlanGenParams.MiddleConfig.name: self._get_middlesearch_config(age),
            PlanGenParams.MiddleData.name: self._get_middlesearch_data(age),
            PlanGenParams.MiddleIndex.name: mmeta_shard_data['shard-resource'],
            PlanGenParams.MiddlePlan.name: self._get_middlesearch_plan(),
            PlanGenParams.MiddleModels.name: self._get_middlesearch_models(),

            PlanGenParams.BasesearchExe.name: self._get_basesearch_executable(age),
            PlanGenParams.BasesearchConfig.name: self._get_basesearch_config(age),
            PlanGenParams.BasesearchDatabase.name: base_shard_data['shard-resource'],

            PlanGenParams.IgnoreIndexGen.name: False,
            PlanGenParams.RequestsNumber.name: self.ctx[RequestsNumberParameter.name],
            PlanGenParams.DisableCache.name: self.ctx[DisableCacheParameter.name],
            PlanGenParams.GroupingSize.name: 0,
            PlanGenParams.BasesearchQueriesCustomParams.name: self._get_basesearch_queries_custom_params(age),
        }
        sub_task = self.create_subtask(
            task_type=GenerateAllPlans.type,
            description='Plan, mmeta_name={}, base_name={}, age={}'.format(mmeta_shard_name, base_shard_name, age),
            input_parameters=sub_ctx,
            arch=sandboxapi.ARCH_LINUX
        )
        return {
            'plan-task': sub_task.id,
            'plan-search-resource': int(sub_task.ctx.get('search_plan_resource_id', 0)),
            'plan-snippets-resource': int(sub_task.ctx.get('snippets_plan_resource_id', 0)),
            'plan-factors-resource': int(sub_task.ctx.get('factors_plan_resource_id', 0)),
        }

    def _sync_subtasks(self):
        utils.check_subtasks_fails(stop_on_broken_children=False, fail_on_first_failure=True)

    def __get_basesearch_shards(self, age):
        base_shard_list = self.ctx[_BASESEARCH_SHARD_KEY.format(age)].split(',')
        return base_shard_list[:self.ctx[ShardsCountParameter.name]]

    def __delta_percent(self, old, new):
        return 100.0 * (new - old) / old if old else 0

    def __average(self, array):
        return sum(array) / len(array) if array else 0

    def __stddev(self, array):
        if not array:
            return 0
        avg_array = self.__average(array)
        return math.sqrt(sum((avg_array - val) ** 2 for val in array) / len(array))

    def __median_rps(self, data):
        import numpy
        warm_data = [a for b in data for a in b[3:]]
        return float(numpy.median(warm_data)) if warm_data else 0


def _make_ctx_key(*args):
    """Helper method to create a key for context"""

    return ','.join(str(a) for a in args)
