# coding: utf-8
from sandbox import sdk2
from sandbox.projects.resource_types import AbstractResource


geowiz_releasers = [
    'algolix',
    'grand',
    'pazdnikov',
    'maxim98',
    'yourmary',
    'savvdm',
    'tivelkov',
    'ityrov',
    'liinda',
]


class PROXY_WIZARD_EXECUTABLE(sdk2.Resource):
    """
        Исполняемый файл прокси колдунщиков, он же базовый класс для всех подтипов
    """
    releasable = True
    any_arch = False
    executable = True
    auto_backup = True
    releasers = [
        'alborisov',
        'alborisov',
        'deemonasd',
        'gavrilovp',
        'lpshka',
        'mvel',  # anti-disaster mode
        'noiseless',
        'petrk',
        'kitesh',
    ] + geowiz_releasers


class PROXY_WIZARD_GEOMISC_EXECUTABLE(PROXY_WIZARD_EXECUTABLE):
    """
        Исполняемый файл прокси для прослойки geomisc
    """


class PROXY_WIZARD_YABS_EXECUTABLE(PROXY_WIZARD_EXECUTABLE):
    """
        Исполняемый файл прокси для прослойки yabs
    """


class PROXY_WIZARD_WEATHER_EXECUTABLE(PROXY_WIZARD_EXECUTABLE):
    """
        Исполняемый файл прокси для прослойки weather
    """
    releasers = PROXY_WIZARD_EXECUTABLE.releasers + ['cmind', 'ftlka', 'WEATHER']

class PROXY_WIZARD_PRAYERS_EXECUTABLE(PROXY_WIZARD_EXECUTABLE):
    """
        Исполняемый файл прокси для прослойки prayers (aka "namaz")
    """


class PROXY_WIZARD_TV_EXECUTABLE(PROXY_WIZARD_EXECUTABLE):
    """
        Исполняемый файл прокси для прослойки тв сниппета.
    """


class PROXY_WIZARD_TAXI_EXECUTABLE(PROXY_WIZARD_EXECUTABLE):
    """
        Исполняемый файл прокси для прослойки такси сниппета.
    """


class PROXY_WIZARD_ROUTES_EXECUTABLE(PROXY_WIZARD_EXECUTABLE):
    """
        Исполняемый файл прокси для прослойки колдунщика маршрутов.
    """
    releasers = PROXY_WIZARD_EXECUTABLE.releasers + ['MAPS-SEARCH-DISCOVERY']


class PROXY_WIZARD_REPORTMISC_EXECUTABLE(PROXY_WIZARD_EXECUTABLE):
    """
        Исполняемый файл прокси для прослойки сниппета колдунов на базе правила report
    """


class WIZARD_SERVICE_UGC_EXECUTABLE(PROXY_WIZARD_EXECUTABLE):
    """
        Исполняемый файл UGC
    """


class PROXY_WIZARD_LYRICS_EXECUTABLE(PROXY_WIZARD_EXECUTABLE):
    """
        Исполняемый файл колдуна Lyrics
    """
    releasers = ["epinkovskii"]


class PROXY_WIZARD_COLORS_EXECUTABLE(PROXY_WIZARD_EXECUTABLE):
    """
        Исполняемый файл прокси для прослойки колдунщика цветов.
    """


class PROXY_WIZARD_ATOM_EXECUTABLE(PROXY_WIZARD_EXECUTABLE):
    """
        Исполняемый файл прокси для прослойки колдунщика atom.
    """


class PROXY_WIZARD_SERIES_EXECUTABLE(PROXY_WIZARD_EXECUTABLE):
    """
        Исполняемый файл прокси для прослойки колдунщика series.
    """


class PROXY_WIZARD_GOSUSLUGI_EXECUTABLE(PROXY_WIZARD_EXECUTABLE):
    """
        Исполняемый файл прокси для прослойки госуслуг
    """


class PROXY_WIZARD_TRAFFIC_EXECUTABLE(PROXY_WIZARD_EXECUTABLE):
    """
        Исполняемый файл прокси для прослойки пробок
    """
    releasers = PROXY_WIZARD_EXECUTABLE.releasers + ['MAPS-SEARCH-DISCOVERY']


class PROXY_WIZARD_AFISHA_EXECUTABLE(PROXY_WIZARD_EXECUTABLE):
    """
        Исполняемый файл прокси для прослойки афиши
    """


class PROXY_WIZARD_AFISHA_MKTRIE_EXECUTABLE(PROXY_WIZARD_EXECUTABLE):
    """
        Исполняемый файл для генерации trie для прослойки афиши
    """


class PROXY_WIZARD_TRANSLATE_EXECUTABLE(PROXY_WIZARD_EXECUTABLE):
    """
        Исполняемый файл прокси для прослойки переводчика
    """


class PROXY_WIZARD_DISTANCE_EXECUTABLE(PROXY_WIZARD_EXECUTABLE):
    """
        Исполняемый файл прокси для прослойки афиши
    """


class PROXY_WIZARD_FASTRES_EXECUTABLE(PROXY_WIZARD_EXECUTABLE):
    """
        Исполняемый файл прокси для прослойки сниппета быстрых колдунщиков.
    """


class PROXY_WIZARD_PAYMENTS_EXECUTABLE(PROXY_WIZARD_EXECUTABLE):
    """
        Исполняемый файл прокси для прослойки сниппета оплаты ядом
    """


class PROXY_WIZARD_CANON_EXECUTABLE(PROXY_WIZARD_EXECUTABLE):
    """
        Исполняемый файл прокси для эмуляции статических ответов источников
    """


class PROXY_WIZARD_UNIVERSAL_EXECUTABLE(PROXY_WIZARD_EXECUTABLE):
    """
        Исполняемый файл универсальной прокси
    """
    releasers = geowiz_releasers


class WIZARD_SERVICE_EVLOGDUMP_EXECUTABLE(AbstractResource):
    """
    Вьювер для eventlog для extsearch/wizards
    """
    releasable = True
    auto_backup = True
    executable = True
    releasers = [
        'petrk', 'stakanviski', 'galaxycrab', 'radix', 'koplyarov', 'rufrozen', 'deep',
        'kamchii', 'fyodor', 'nataxane', 'qqq', 'vladon', 'alborisov', 'juliana-zh', 'sildtm', 'epinkovskii',
    ] + geowiz_releasers
