# coding: utf-8

import logging
import urllib2
import time

from os.path import join as pj

from sandbox.sandboxsdk.channel import channel
from sandbox.sandboxsdk.errors import SandboxTaskFailureError
from sandbox.sandboxsdk import process

from sandbox.projects.resource_types import EVLOGDUMP_EXECUTABLE, EVLOG2STATS_EXECUTABLE
from sandbox.projects.common.utils import wait_searcher_start, wait_searcher_stop

from . import executable_types as resources


def construct_proxy_provider(proxy_build, config_path, proxy_port):
    return ProxyProvider(proxy_build, config_path, proxy_port)


WIZARDS_ROOT = 'extsearch/wizards'


def wj(top, *other):
    if len(other) == 0:
        return pj(WIZARDS_ROOT, top, top)
    return pj(WIZARDS_ROOT, *other)


class ProxyTypes(object):
    proxies = {
        'traffic': (resources.PROXY_WIZARD_TRAFFIC_EXECUTABLE, 'extsearch/wizards/traffic/traffic'),
        'afisha': (resources.PROXY_WIZARD_AFISHA_EXECUTABLE, 'extsearch/wizards/afisha/daemon/afisha'),
        'fastres': (resources.PROXY_WIZARD_FASTRES_EXECUTABLE, wj('fastres')),
        'payments': (resources.PROXY_WIZARD_PAYMENTS_EXECUTABLE, 'extsearch/wizards/payments/payments'),
        'geomisc': (resources.PROXY_WIZARD_GEOMISC_EXECUTABLE, 'extsearch/wizards/geomisc/daemon/geomisc'),
        'yabs': (resources.PROXY_WIZARD_YABS_EXECUTABLE, wj('yabs')),
        'weather': (resources.PROXY_WIZARD_WEATHER_EXECUTABLE, 'extsearch/wizards/weather/daemon/weather'),
        'translate': (resources.PROXY_WIZARD_TRANSLATE_EXECUTABLE, wj('translate')),
        'taxi_proxy': (resources.PROXY_WIZARD_TAXI_EXECUTABLE, 'extsearch/wizards/taxi/daemon/taxi_proxy'),
        'routes': (resources.PROXY_WIZARD_ROUTES_EXECUTABLE, wj('routes')),
        'report_misc_proxy': (resources.PROXY_WIZARD_REPORTMISC_EXECUTABLE, 'extsearch/wizards/reportmisc/daemon/report_misc_proxy'),
        'colors': (resources.PROXY_WIZARD_COLORS_EXECUTABLE, 'extsearch/wizards/colors/colors'),
        'distance': (resources.PROXY_WIZARD_DISTANCE_EXECUTABLE, wj('distance')),
        'atom': (resources.PROXY_WIZARD_ATOM_EXECUTABLE, wj('atom')),
        'gosuslugi': (resources.PROXY_WIZARD_GOSUSLUGI_EXECUTABLE, wj('gosuslugi')),
        'series': (resources.PROXY_WIZARD_SERIES_EXECUTABLE, wj('series')),
        'universal': (resources.PROXY_WIZARD_UNIVERSAL_EXECUTABLE, wj('charon_proxy')),
        'lyrics': (resources.PROXY_WIZARD_LYRICS_EXECUTABLE, wj('lyrics')),
    }
    others = {
        'evlogdump': (EVLOGDUMP_EXECUTABLE, 'search/tools/evlogdump/evlogdump'),
        'evlog2stat': (EVLOG2STATS_EXECUTABLE, 'extsearch/wizards/common/tools/evlog2stat/evlog2stat'),
        'afisha_mktrie': (resources.PROXY_WIZARD_AFISHA_MKTRIE_EXECUTABLE, wj('afisha', 'mktrie', 'mktrie')),
        'canon': (resources.PROXY_WIZARD_CANON_EXECUTABLE, wj('canon', 'daemon', 'canon'))
    }

    @classmethod
    def construct_build_fields(cls):
        fields = []
        for k in sorted(cls.proxies.keys()):
            fields.append(k)
        for k in sorted(cls.others.keys()):
            fields.append(k)
        return {'projects': fields}

    @classmethod
    def construct_target_resources(cls):
        targets = []
        for kp in sorted(cls.proxies.keys()):
            resource_type, arcadia_build_path = cls.proxies[kp]
            targets.append((resource_type, kp, arcadia_build_path))
        for ko in sorted(cls.others.keys()):
            resource_type, arcadia_build_path = cls.others[ko]
            targets.append((resource_type, ko, arcadia_build_path))
        return targets


class ProxyProvider(object):
    host = 'localhost'
    port = 19245

    def __init__(
        self, proxy_build, config_path, proxy_port, stderr=None
    ):
        self.proxy_id = proxy_build
        self.config_path = config_path
        self.port = proxy_port

        logging.info('Bin params: port {}'.format(self.port))

        self.binary_path = None
        self.timestamp = time.time()

        self.eventlog = 'proxy.{}.eventlog'.format(self.port)
        self.logger = 'proxy.{}.log'.format(self.port)

        self.process = None
        self.stderr = stderr

        self.get_proxy_binary()
        self.cmd = self.get_run_cmd()
    """
    def get_memory(self):
        return psutil.Process(self.process.pid).get_memory_info().rss
    """

    def get_proxy_binary(self):
        logging.info('syncing wizard_proxy binary resource #{}'.format(self.proxy_id))
        self.binary_path = channel.task.sync_resource(self.proxy_id)
        logging.info('synced proxy binary to {}'.format(self.binary_path))

    def get_run_cmd(self):
        cmd = '%s %s' % (self.binary_path, self.config_path)
        return cmd

    def start(self):
        logging.info('starting proxy_wizard')
        if not self.alive():
            self.process = process.run_process(
                self.cmd.split(), check=True, outputs_to_one_file=False, wait=False,
                log_prefix='proxy_%s' % self.timestamp)
            logging.info('===waiting for proxy_wizard to start'.format(wizard=self))
            wait_searcher_start(self.host, self.port, subproc_list=[self.process], timeout=30)
        else:
            logging.info('still alive')

    def stop(self):
        logging.info('stopping proxy')
        if not self.alive():
            logging.info('Proxy is not alive when stopping')
            raise SandboxTaskFailureError('proxy is dead')
        else:
            logging.info('Stopping {proxy.host}:{proxy.port}'.format(proxy=self))
            url = 'http://{proxy.host}:{proxy.port}/admin?action=shutdown'.format(proxy=self)
            urllib2.urlopen(url, timeout=5).read()
            wait_searcher_stop(self.host, self.port, timeout=30 * 60)
            self.process = None

    def alive(self):
        return self.process and self.process.poll() is None

    def __enter__(self):
        self.start()
        return self

    def __exit__(self, type, value, traceback):
        self.stop()
