from sandbox.projects.common.juggler_notifying_sandbox_task import JugglerNotifyingSandboxTask


class QuentaoTask(JugglerNotifyingSandboxTask):
    juggler_source = 'quentao_build_monitoring'

    readable_task_name = ''
    short_task_name = ''

    def get_juggler_description(self):
        sanbox_base_url = 'https://sandbox.yandex-team.ru/task'
        descr = '{readable_task_name} (sb task {base_url}/{task_id} )'.format(
            readable_task_name=self.readable_task_name,
            base_url=sanbox_base_url,
            task_id=self.id,
        )
        return descr

    def get_juggler_host(self):
        return 'quentao_sandbox_{}_task'.format(self.short_task_name)

    def get_juggler_service(self):
        return 'success'
