# coding: utf-8

from sandbox.sandboxsdk import parameters as sp
from sandbox.projects import resource_types


class UsePersonalUidsParameter(sp.SandboxBoolParameter):
    name = 'use_personal_uids'
    choices = (
        ('specific', 'specific'),
        ('random', 'random'),
    )
    default_value = False
    sub_fields = {'true': ['personal_uids_resource_id']}
    description = 'Use Personalized Requests'


class PersonalUidsResourceParameter(sp.ResourceSelector):
    name = 'personal_uids_resource_id'
    required = False
    description = 'Select resource with personal uids'
    resource_type = resource_types.YANDEX_UID_LIST
    do_not_copy = True


PERSONAL_UIDS_PARAMETERS = (
    UsePersonalUidsParameter,
    PersonalUidsResourceParameter,
)


class ReleaseMachineModeParameter(sp.SandboxBoolParameter):
    name = "release_machine_mode"
    description = "Whether the task is launched by Release Machine"
    required = False
    default_value = False


class ReleaseMachineComponentNameParameter(sp.SandboxStringParameter):
    name = "component_name"
    description = "Release Machine component name"
    required = False
    default_value = ''


class ReleaseMachineLaunchVerboseNameParameter(sp.SandboxStringParameter):
    name = "launch_verbose_name"
    description = "Any name that identifies the launch"
    required = False
    default_value = ''


class ReleaseMachineScopeNumberParameter(sp.SandboxIntegerParameter):
    name = "scope_number"
    description = "Release machine component scope number"
    required = False
    default_value = 0


class ReleaseMachineRevisionParameter(sp.SandboxIntegerParameter):
    name = "revision"
    description = "Launch revision"
    required = False
    default_value = 0


RELEASE_MACHINE_PARAMETERS = (
    ReleaseMachineModeParameter,
    ReleaseMachineComponentNameParameter,
    ReleaseMachineLaunchVerboseNameParameter,
    ReleaseMachineScopeNumberParameter,
    ReleaseMachineRevisionParameter,
)
