#!/usr/bin/env python
import six

from sandbox.projects.common.reactor.rest_api import RestApi


class ReactorApi(RestApi):
    def __init__(self, token):
        super(ReactorApi, self).__init__(
            token,
            netloc="reactor.yandex-team.ru",
            api_root="/api/v1/",
            scheme="https"
        )

    def getLastArtifactInstance(self, artifact_id):
        method = "a/i/get/last"
        data = {
            "artifactIdentifier": {
                "artifactId": artifact_id
            }
        }
        return self._post(method, data)

    def getArtifactById(self, artifact_id):
        return {
            "artifactId": artifact_id
        }

    def getArtifactByNamespace(self, artifact_namespace):
        return {
            "namespaceIdentifier": {
                "namespacePath": artifact_namespace
            }
        }

    def instantiateArtifact(self, artifact, metadata, attributes={}):
        method = "a/i/instantiate"
        getter = self.getArtifactByNamespace if isinstance(artifact, (str, six.text_type)) else self.getArtifactById
        data = {
            "artifactIdentifier": getter(artifact),
            "metadata": metadata,
            "attributes": attributes
        }
        return self._post(method, data)

    def instantiateStringArtifact(self, artifact_id, string_value, attributes={}):
        return self.instantiateArtifact(artifact_id, {
            "@type": "/yandex.reactor.artifact.StringArtifactValueProto",
            "value": string_value
        }, attributes)

    def instantiateIntArtifact(self, artifact_id, int_value, attributes={}):
        return self.instantiateArtifact(artifact_id, {
            "@type": "/yandex.reactor.artifact.IntArtifactValueProto",
            "value": int_value
        }, attributes)
