#!/usr/bin/env python
# -*- coding: utf-8 -*-
import hashlib
import json
import requests
from sandbox.projects.common.BaseTestTask import BaseDolbiloTask
from sandbox.projects.sandbox_ci.resources import ReportWebTemplatesPackage
from sandbox.projects.sandbox_ci.pulse.resources import ReportRendererPlan
from sandbox.projects.sandbox_ci.resources import WebMicroPackage


def generate_routes(renderer_configs, is_images=False):
    url = 'https://github.yandex-team.ru/raw/search-interfaces/routes/dev/%s.json' \
        % ('routes.images' if is_images else 'routes')
    res = requests.get(url)
    assert res.status_code == 200, str(res.status_code) + ' ' + url
    routes = json.loads(res.text)
    routes = filter(lambda route: route.get('renderer') in renderer_configs, routes)
    return json.dumps(routes, indent=4)


# Список параметров бенчмарка BENCHMARK_REPORT_RENDERER_BASE, которые влияют на результат
BENCHMARK_IMPORTANT_KEYS = (
    # Benchmark parameters
    'benchmark_plan',
    'report_renderer_bundle',
    'report_templates_package',

    # Dolbilo parameters
    'circular',
    'd_executor_augmenturl',
    'do_not_remove_dolbilka_results',
    'do_trace',
    'dolbilo_options_info',
    'executor_mode',
    'max_service_unavailable',
    'plan_memory',
    'requests_limit',
    'start_timeout',
    'total_sessions',
)


def _get_benchmark_important_keys(params):
    """
    Возвращает список ключей, влияющих на результат бенчмарка
    :param params: dict - словарь с параметрами задачи
    :return: tuple
    """
    return BENCHMARK_IMPORTANT_KEYS + tuple(BaseDolbiloTask.ExecutorMode.sub_fields[params['executor_mode']])


def params_hash(params):
    """
    Возвращает хеш от параметров задачи бенчмарка
    :param params: dict - словарь с параметрами задачи. Может иметь лишние значения, для хеша будут использованы только
    те ключи, которые влияют на результат бенчмарка
    :return: string
    """
    important_params = {}
    for key in _get_benchmark_important_keys(params):
        important_params[key] = params.get(key, None)
    res = hashlib.sha1(json.dumps(important_params, sort_keys=True)).hexdigest()
    return res


def default_benchmark_plan():
    """
    План, который удобно использовать для запусков бенчмарка
    :return: sdk2 resource
    """
    return ReportRendererPlan.find(attrs={'released': 'stable', 'platform': 'touch', 'project': 'web4'}).first()


def default_templates_package():
    """
    Шаблоны, которые удобно использовать для запусков бенчмарка
    :return: sdk2 resource
    """
    return WebMicroPackage.find(attrs={'released': 'stable', 'project': 'web4'}).first()


def default_empty_templates_package():
    """
    Пустые шаблоны, которые удобно использовать для запусков бенчмарка памяти воркера
    :return: sdk2 resource
    """
    return ReportWebTemplatesPackage.find(attrs={'platform': 'empty-test'}).first()
