# sandbox-specific decorators

import logging

import sandbox.common.errors as ce


def retries_on_different_clients(exceptions=(Exception,)):
    """
        Wraps function into subsequent attempts using TemporaryError (try on another client).
        Retries number is controlled by Sandbox (10 typically).
    """

    def __call_str(function, args, kwargs):
        call = function.__name__ + u"(" + u", ".join([repr(s) for s in args])
        if len(args) and len(kwargs):
            call += u", "
        call += u", ".join([k + u"=" + repr(v) for k, v in kwargs.iteritems()])
        call += u")"
        return call

    def dec(func):
        def f2(*args, **kwargs):
            try:
                return func(*args, **kwargs)
            except exceptions as e:
                logging.error(
                    "Error in function %s:\n%s\nRaising TemporaryError to try on another client",
                    __call_str(func, args, kwargs), e
                )
                info = "Error:\n{}\nRaising TemporaryError to try on another client".format(e)
                raise ce.TemporaryError(info)
        return f2
    return dec
