# -*- coding: utf-8 -*-

from sandbox.sandboxsdk.channel import channel
from sandbox.sandboxsdk import parameters as sp


def mark_hosts_with_resources(hosts):
    """
        Нужна для запуска задач на хостах c наибольшим суммарным размером нужных ресурсов.
        Присваивает хостам вес от 0 до 100 в зависимости от суммы размеров ресурсов на хосте
        относительно размеров всех нужных ресурсов.
        Использовать в функции hosts_match_score().
    """
    task = channel.task
    resources = []
    for param in task.input_parameters:
        if issubclass(param, sp.ResourceSelector):
            resource_id = task.ctx.get(param.name, None)
            if resource_id:
                resources.append(resource_id)

    resources_hosts = []
    sizes = []
    total_size = 0
    for resource_id in resources:
        resources_hosts.append(channel.sandbox.get_resource_hosts(resource_id))
        resource_size = channel.sandbox.get_resource(resource_id).size
        sizes.append(resource_size)
        total_size += resource_size

    scores = []
    for host in hosts:
        host_score = 0
        for r in range(len(resources)):
            if host.hostname in resources_hosts[r]:
                host_score += sizes[r]
        scores.append(int((float(host_score) / total_size) * 100))

    return scores
