# -*- coding: utf-8 -*-

from sandbox.sandboxsdk import parameters

import sandbox.projects.websearch.middlesearch.resources as ms_resources
from sandbox.projects import resource_types
from sandbox.projects.common.search.components import create_middlesearch_params

DEFAULT_TABLE_FIELDS = [
    'RequestTime.Avg',
    'MetaSearchTime.Avg',
    'SearchTime.Avg',
    'FetchTime.Avg',
    'CacheLoad.Avg',
    'SubSourceSearch.Avg',
    'SubSourceSearch.Count',
    'SubSourceSnippets.Avg',
    'SubSourceSnippets.Count',
    'ReAskSubSource.Count'
]


def create_resource_params(n=None, group_name=None, use_int=False, with_evlogdump=True):
    base = create_middlesearch_params(n=n, with_evlogdump=with_evlogdump, with_config=True, use_int=use_int)

    class Params(base):
        class Requests(parameters.ResourceSelector):
            name = (
                'middlesearch_request_resource_id' if n is None
                else ('middlesearch_request_{}_resource_id'.format(n))
            )
            description = 'Requests'
            resource_type = [
                resource_types.PLAIN_TEXT_QUERIES,
                ms_resources.WebMiddlesearchPlainTextQueries,
                resource_types.IMAGES_MIDDLESEARCH_PLAIN_TEXT_REQUESTS,
                resource_types.VIDEO_MIDDLESEARCH_PLAIN_TEXT_REQUESTS,
            ]
            group = 'Middlesearch parameters' if n is None else ('Middlesearch {} parameters'.format(n))
            required = True

        params = base.params + (Requests, )

    if group_name:
        for p in Params.params:
            p.group = group_name

    return Params


def create_shooting_params(middle_type=''):
    group_name = 'Shooting params'
    prefix = ''

    if middle_type:
        group_name += ' for {}'.format(middle_type)
        prefix += '{}_'.format(middle_type)

    class ShootingParams(object):
        class ReqCount(parameters.SandboxIntegerParameter):
            name = '{}req_count'.format(prefix)
            description = 'Number of requests to shoot'
            group = group_name
            default_value = 15000

        class Rps(parameters.SandboxIntegerParameter):
            name = '{}rps'.format(prefix)
            description = 'RPS'
            group = group_name
            default_value = [20, 50][middle_type == 'int']

        class Nruns(parameters.SandboxIntegerParameter):
            name = '{}nruns'.format(prefix)
            description = 'Number of test runs'
            group = group_name
            default_value = 4

        class Nrepeats(parameters.SandboxIntegerParameter):
            name = '{}nrepeats'.format(prefix)
            description = 'Number of repeats on last run'
            group = group_name
            default_value = [4, 1][middle_type == 'int']

        class ReverseRequests(parameters.SandboxBoolParameter):
            name = '{}reverse_requests'.format(prefix)
            description = 'Reverse second requests'
            group = group_name
            default_value = False

        class SequentialShooting(parameters.SandboxBoolParameter):
            name = '{}sequential_shooting'.format(prefix)
            description = 'Sequential shooting'
            group = group_name
            default_value = False

        class ShuffleShootingOrder(parameters.SandboxBoolParameter):
            name = '{}shuffle_shooting_order'.format(prefix)
            description = 'Shuffle shooting order'
            group = group_name
            default_value = False

        class WarmupRequestCount(parameters.SandboxIntegerParameter):
            name = '{}warmup_request_count'.format(prefix)
            description = 'Warmup requests count'
            group = group_name
            default_value = 500

        class NoCacheMode(parameters.SandboxBoolParameter):
            name = '{}nocache_mode'.format(prefix)
            description = 'Add nocache=da to first repeat in each run'
            group = group_name
            default_value = True

        class CacheMode(parameters.SandboxBoolParameter):
            name = '{}cache_mode'.format(prefix)
            description = 'First fill cache, then repeat requests'
            group = group_name
            default_value = False

        class RestartMode(parameters.SandboxBoolParameter):
            name = '{}restart_mode'.format(prefix)
            description = 'Restart metasearch and clear cache between each run'
            group = group_name
            default_value = True

        class CacheCompatibilityMode(parameters.SandboxBoolParameter):
            name = '{}cache_compatibility_mode'.format(prefix)
            description = 'First fill cache as in first conf, than always shoot above that cache'
            group = group_name
            default_value = False

        params = (
            ReqCount,
            Rps,
            Nruns,
            Nrepeats,
            ReverseRequests,
            SequentialShooting,
            ShuffleShootingOrder,
            WarmupRequestCount,
            NoCacheMode,
            CacheMode,
            RestartMode,
            CacheCompatibilityMode,
        )

    return ShootingParams


def create_eventlog_stat_params(group_name='Stat params'):
    class StatParams(object):
        class AdditionalStatCounters(parameters.SandboxStringParameter):
            name = 'additional_stat_counters'
            description = 'Additional stat counters'
            group = group_name
            default_value = ''

        class HistogrammOptions(parameters.SandboxStringParameter):
            name = 'histogramm_options'
            description = 'Histogramm options'
            group = group_name
            default_value = ''

        class TableFields(parameters.SandboxStringParameter):
            name = 'table_fields'
            description = 'Table fields'
            group = group_name
            default_value = ','.join(DEFAULT_TABLE_FIELDS)

        class ByGrouping(parameters.SandboxBoolParameter):
            name = 'by_grouping'
            description = 'Extended stats by grouping'
            group = group_name
            default_value = False

        class CalcMode(parameters.SandboxStringParameter):
            name = 'calc_mode'
            description = 'Calc mode'
            group = group_name
            choices = [
                ("middle", "middle"),
                ("blender", "blender"),
                ("ydo", "ydo")
            ]
            sub_fields = {
                "blender": ['by_grouping'],
            }
            default_value = "middle"

        class RearrangeAdjustersStat(parameters.SandboxBoolParameter):
            name = 'calc_rearrange_adjusters_stat'
            description = 'whether to calc detailed stat within PrepareClients'
            group = group_name
            default_value = False

        params = (AdditionalStatCounters, HistogrammOptions, TableFields, CalcMode, ByGrouping, RearrangeAdjustersStat)

    return StatParams


def create_eventlog_resource_params(group_name='Eventlog params'):
    class EventlogParams(object):
        class Eventlog(parameters.ResourceSelector):
            name = 'eventlog_res'
            description = 'Eventlog'
            group = group_name
            resource_type = resource_types.EVENTLOG_DUMP
            required = True

        class OldRearrangeStagesOrder(parameters.SandboxBoolParameter):
            name = 'old_rearrange_stages_order'
            description = 'Use old rearrange stages order (SEARCH-8183)'
            default_value = False

        params = (Eventlog, OldRearrangeStagesOrder,)

    return EventlogParams


KEY_OUT_EVENTLOGS = 'output_evlog_res_ids'
