# -*- coding: utf-8 -*-
import logging
import sandbox.projects.common.search.components.component as components_common


DEFAULT_APPHOST_PORT = 8870
DEFAULT_START_TIMEOUT = 600


class AppHost(
    components_common.WaitPortComponentMixin,
    components_common.ProcessComponentMixinWithShutdown,
    components_common.Component,
):
    name = "app_host"

    def __init__(self, task, binary_path, config_path, port=DEFAULT_APPHOST_PORT,
                 start_timeout=DEFAULT_START_TIMEOUT, no_memlock=False):
        self.task = task
        self.binary_path = binary_path
        self.config_path = config_path
        self.port = port
        self.start_timeout = start_timeout

        args = [self.binary_path, "--config", self.config_path, "-p", str(self.port)]
        if no_memlock:
            args += ['--no-mlock']

        components_common.WaitPortComponentMixin.__init__(
            self, endpoints=[("localhost", port)], wait_timeout=start_timeout
        )
        components_common.ProcessComponentMixinWithShutdown.__init__(
            self,
            args=args,
            shutdown_url="http://localhost:{}/admin?action=shutdown".format(self.port),
            log_prefix=self.name,
        )
        logging.info("Component '%s' initialized successfully", self.name)
