# -*- coding: utf-8 -*-
import httplib
import os
import time
import urllib2

from sandbox.sandboxsdk import process

from sandbox.projects import resource_types
from sandbox.projects.common import apihelpers
from sandbox.projects.common import error_handlers as eh
from sandbox.projects.common.search.components import SearchComponent


class Cproxy(SearchComponent):
    name = 'cproxy'

    def __init__(self, binary, hosts=None, task=None):
        """
            Обёртка для cproxy
            binary - путь до бинарника
            hosts - словарь = {локальные свободные порты: хосты для проксирования}
            task - объект таска
        """
        SearchComponent.__init__(self, task)
        self.hosts = hosts
        self.binary = os.path.abspath(binary)

    def start(self, timeout=None, save_logs=False):
        """
             Запуск cproxy. Для каждой пары хост:порт из host_list задаётся порт на localhost
             После запуска cproxy возвращается объект процесса
        """
        if save_logs:
            log_prefix = 'start_{}'.format(self.name)
        else:
            log_prefix = None
        if not self.hosts:
            eh.check_failed('Cannot run cproxy: hosts list is empty')
        parameters = [self.binary, '-inmem']
        for local_port, replaced_host in self.hosts.items():
            parameters.append('{}:{}'.format(local_port, replaced_host))
        self.process_parameters = parameters
        self.process = process.run_process(parameters, wait=False, log_prefix=log_prefix)
        if timeout:
            timeout = int(timeout)
        else:
            timeout = 240
        for test_port in self.hosts.keys():
            self.wait_port(test_port, timeout)
        return self.process

    def wait_port(self, port=None, timeout=120):
        if not port:
            port = self.hosts.keys()[0]
        start_time = time.time()
        while (time.time() - start_time) > timeout:
            try:
                urllib2.urlopen('http://127.0.0.1:{}'.format(port))
                return True
            except (urllib2.URLError, httplib.BadStatusLine):
                time.sleep(10)


def get_cproxy(task, hosts):
    """
        Возвращает обёртку для cproxy.

        :param task: объект таска - нужен для выполнения через него ряда операций
        :param hosts: словарь, ключи которого - локальные свободные порты, а значения - хосты для проксирования
    """
    cproxy_resource = apihelpers.get_last_resource(resource_types.CPROXY_EXECUTABLE)
    eh.verify(cproxy_resource, "CPROXY_EXECUTABLE was not found")
    cproxy_path = task.sync_resource(cproxy_resource)
    return Cproxy(binary=cproxy_path, hosts=hosts, task=task)
