# coding: utf-8
"""
    Search database shards based on CAJUPER_TRACKER_CLIENT tool
    Maintainers: anskor@
"""

import logging
import subprocess
from sandbox.sandboxsdk import process
from sandbox.sandboxsdk import sandboxapi
from sandbox.sandboxsdk.channel import channel

from sandbox.projects.cajuper.resources import CajuperTrackerClient
from sandbox.projects.common import decorators
from sandbox.projects.common import utils


def get_shard_name(shard_name):
    TOOL_NAME = "/tracker_client"
    try:
        tool_id = _get_cajuper_tracker_tool()
        if tool_id is None:
            return None
        tool_path = channel.task.sync_resource(tool_id) + TOOL_NAME
        return _try_cajuper_tracker_shard_name(shard_name, tool_path).strip()
    except Exception as e:
        logging.error("Problem during search in CajuperTracker: %s", e)
    return None


@decorators.memoize
def _get_cajuper_tracker_tool():
    try:
        return utils.get_and_check_last_released_resource_id(
            CajuperTrackerClient,
            arch=sandboxapi.ARCH_ANY
        )
    except Exception as e:
        logging.error("Cannot get latest stable CAJUPER_TRACKER_CLIENT tool: %s", e)
    return None


@decorators.retries(3, 1)
def _try_cajuper_tracker_shard_name(shard_name, tool_path):
    logging.info("Trying CajuperTracker...")
    tool_proc = process.run_process(
        [tool_path, shard_name],
        stdout=subprocess.PIPE,
        wait=False,
        outputs_to_one_file=False,
        log_prefix="cajuper_tracker",
    )
    tool_stdout = ""
    try:
        tool_stdout, _ = tool_proc.communicate()
    finally:
        tool_rc = tool_proc.wait()
        if tool_rc == 0:
            return tool_stdout
        else:
            raise Exception("Failed to communicate with CajuperTracker...")
