# coding: utf-8
"""
    Search database shards based on ISS and ISS_SHARDS tools
    Maintainers: mvel@, kulikov@
"""
import json
import logging
import subprocess
from sandbox.sandboxsdk import process
from sandbox.sandboxsdk import sandboxapi

from sandbox.projects.common import decorators
from sandbox.projects.common import utils
from sandbox.sandboxsdk.channel import channel

from sandbox.projects import resource_types


def get_shard_name(shard_name):
    try:
        tool_id = _get_iss_shards_tool()
        if tool_id is None:
            return None
        return _try_iss_shard_name(shard_name, channel.task.sync_resource(tool_id))
    except Exception as e:
        logging.error("Problem during search in ShardTracker: %s", e)
    return None


@decorators.memoize
def _get_iss_shards_tool():
    try:
        return utils.get_and_check_last_released_resource_id(
            resource_types.ISS_SHARDS,
            arch=sandboxapi.ARCH_ANY
        )
    except Exception as e:
        logging.error("Cannot get latest stable ISS_SHARDS tool: %s", e)
    return None


@decorators.retries(3, 1)
def _try_iss_shard_name(shard_name, tool_path):
    logging.info("Trying ShardTracker...")
    tool_proc = process.run_process(
        [tool_path, "info", "--json", shard_name],
        stdout=subprocess.PIPE,
        wait=False,
        outputs_to_one_file=False,
        log_prefix="iss_shards",
    )
    tool_stdout = ""
    try:
        tool_stdout, _ = tool_proc.communicate()
    finally:
        tool_rc = tool_proc.wait()
        if tool_rc == 0:
            return json.loads(tool_stdout)["full"]["urls"][0]
        else:
            raise Exception("Failed to communicate with ShardTracker")
