# -*- coding: utf-8 -*-
"""
    This file should NOT have any dependence on custom libraries (including sandboxsdk)
"""

import os
import subprocess


class Config:
    def __init__(self, path):
        self.path = path
        self.props = {}

    def indexdir(self):
        return self.props['IndexDir']

    def evlogdump(self):
        return os.path.join(self.path, 'evlogdump')


class BSConfig:
    PATH = ["/Berkanavt/bin/scripts/bsconfig", "/db/bin/bsconfig"]

    def __init__(self):
        for bsconfig_path in self.PATH:
            if os.path.isfile(bsconfig_path):
                break
        else:
            raise Exception("Failed to find bsconfig executable. Search paths are {}".format(self.PATH))

        self.configs = {}

        command = [bsconfig_path, "list"]
        p = subprocess.Popen(command, stdout=subprocess.PIPE, stderr=subprocess.PIPE)
        bsconfig_out, stderr = p.communicate()

        if p.returncode:
            err_msg = "Command [{}], return code: {}, stderr:\n{}".format(" ".join(command), p.returncode, stderr)
            raise Exception(err_msg)

        key = None
        for line in bsconfig_out.split("\n"):
            if not len(line):
                continue
            elif line[0] == '/':
                line = line.split()
                key = int(line[0][line[0].rfind(':') + 1:])
                self.configs[key] = Config(line[0])
            elif key is not None:
                k, v = line.strip().split(' ')
                self.configs[key].props[k] = v

    def __getitem__(self, key):
        if key not in self.configs:
            raise Exception("incorrect instance port {}. bsconfig list instances: {}".format(key, self.configs.keys()))
        return self.configs[key]
