# -*- coding: utf-8 -*-
"""
    This file should NOT have any dependence on custom libraries (including sandboxsdk)
"""

import os
import subprocess


class Config:
    def __init__(self, path):
        self.path = path
        self.props = {}

    def indexdir(self):
        return self.props['IndexDir']

    def evlogdump(self):
        return os.path.join(self.path, 'evlogdump')


class IssConfig:
    # parse iss output like:
    # /place/db/iss3/instances/29546_production_src_setup_msk_webhamster_M5wHUNio0nB :
    #    Id: production_src_setup_msk_webhamster#production_src_setup_msk_webhamster-1486116697497  [ACTIVE]
    #    Port: 29546
    #    IndexDir: ./

    PATH = ["/usr/bin/ih"]

    def __init__(self):
        for ih_path in self.PATH:
            if os.path.isfile(ih_path):
                break
        else:
            raise Exception("Failed to find ih executable. Search paths are {}".format(self.PATH))

        self.configs = {}

        command = [ih_path, "list"]
        p = subprocess.Popen(command, stdout=subprocess.PIPE, stderr=subprocess.PIPE)
        ih_out, stderr = p.communicate()

        if p.returncode:
            err_msg = "Command [{}], return code: {}, stderr:\n{}".format(" ".join(command), p.returncode, stderr)
            raise Exception(err_msg)

        inst_path = None
        active = True
        for line in ih_out.split("\n"):
            line = line.strip(' ')
            if not len(line):
                continue
            elif line[0] == '/':
                tk = line.split()
                inst_path = tk[0]
                active = False
            else:
                tk = line.split()
                if tk[0] == 'Id:':
                    if tk[-1] == '[ACTIVE]':
                        active = True
                elif tk[0] == 'Port:':
                    if active:
                        self.configs[int(tk[1])] = Config(inst_path)
                        inst_path = None

    def __getitem__(self, key):
        if key not in self.configs:
            raise Exception("incorrect instance port {}. ih list instances: {}".format(key, self.configs.keys()))
        return self.configs[key]
