# -*- coding: utf-8 -*-

from sandbox.sandboxsdk.channel import channel
from sandbox.projects.common.search import components as sc

_basesearch_1_params = sc.create_basesearch_params(1)
_basesearch_2_params = sc.create_basesearch_params(2)


def compare_memory_usage(
    first_basesearch, first_middlesearch,
    second_basesearch=None, second_middlesearch=None,
    description=""
):
    if second_basesearch is None:
        second_basesearch = first_basesearch
    if second_middlesearch is None:
        second_middlesearch = first_middlesearch

    memusage_task_1_id = _create_measure_memory_task(
        first_basesearch, first_middlesearch, '{}: compare memory usage: first'.format(description)
    )
    memusage_task_2_id = _create_measure_memory_task(
        second_basesearch, second_middlesearch, '{}: compare memory usage: second'.format(description)
    )
    return (
        memusage_task_1_id,
        memusage_task_2_id
    )


def _create_measure_memory_task(basesearch, mmeta, description):
    sub_ctx = {
        sc.DefaultMiddlesearchParams.Binary.name: mmeta.executable,
        sc.DefaultMiddlesearchParams.Config.name: mmeta.config,
        sc.DefaultMiddlesearchParams.Data.name: mmeta.data,
        sc.DefaultMiddlesearchParams.ArchiveModel.name: mmeta.models,
        'dolbilo_plan_resource_id': mmeta.plan,
        'notify_via': '',
        'process_count': 4,  # do not overshoot basesearch (SEARCH-1044)
    }

    if mmeta.verify_stderr is not None:
        sub_ctx.update({'middlesearch_verify_stderr': mmeta.verify_stderr})

    if basesearch is not None:
        sub_ctx.update({
            _basesearch_1_params.Binary.name: basesearch.executable,
            _basesearch_2_params.Binary.name: basesearch.executable,
            _basesearch_1_params.Config.name: basesearch.config1,
            _basesearch_2_params.Config.name: basesearch.config2,
            _basesearch_1_params.Database.name: basesearch.database1,
            _basesearch_2_params.Database.name: basesearch.database2,
            _basesearch_1_params.ArchiveModel.name: basesearch.models_base,
            _basesearch_2_params.ArchiveModel.name: basesearch.models_base,
        })
    else:
        sub_ctx.update({'replace_basesearches': False})

    task_id = channel.task.create_subtask(
        task_type='MEASURE_MIDDLESEARCH_MEMORY_USAGE',
        description=description,
        input_parameters=sub_ctx,
        arch='linux'
    ).id

    return task_id
