# -*- coding: utf-8 -*-
import logging

from sandbox.sandboxsdk import parameters as sp
from sandbox.sandboxsdk import paths
from sandbox.sandboxsdk import process
from sandbox.projects.common import error_handlers as eh
from sandbox.projects.common import utils


def get_params():

    class Params:

        class DumpSubsourceAnswers(sp.SandboxBoolParameter):
            name = 'dump_subsource_answer'
            description = 'Dump subsource answer to eventlog'
            group = 'Debug'
            default_value = False

        class UseTcpdump(sp.SandboxBoolParameter):
            name = 'use_tcpdump'
            description = 'Enable tcpdump sniffing'
            group = 'Debug'
            default_value = False

        class UseCproxy(sp.SandboxBoolParameter):
            name = 'use_cproxy'
            description = 'Use cproxy'
            group = 'Debug'
            default_value = False

        params = (
            DumpSubsourceAnswers,
            UseTcpdump,
            UseCproxy,
        )

    return Params


PARAMS = get_params()

dump_grouping_cgi = '&rearr=scheme_Local/DumpGrouping=1&dump_groupings=yes'
dump_subsource_answer_cgi = "&debug=logsrcanswer"


def use_cproxy(ctx):
    return utils.get_or_default(ctx, PARAMS.UseCproxy)


def use_tcpdump(ctx):
    return utils.get_or_default(ctx, PARAMS.UseTcpdump)


def dump_subsource_answer(ctx):
    return utils.get_or_default(ctx, PARAMS.DumpSubsourceAnswers)


def dump_subsource_answer_patcher(q):
    return q + dump_subsource_answer_cgi


def dump_grouping_patcher(q):
    return q + dump_grouping_cgi


def remove_eventlog_frame_dump_patcher(q):
    return q.replace('&debug=eventlogs', '')


def lua_rearrange_time_limit_patcher(q):
    return q + '&pron=lua_rearrange_time_limit_80'


def start_tcpdump(ctx, ports):
    if not use_tcpdump(ctx):
        return None

    eh.verify(ports, "At least one port should be specified for tcpdump sniffing")

    port_params = []
    for p in ports:
        port_params += ['or', str(p)]
    port_params = port_params[1:]

    tcp_dump_proc = process.run_process(
        [
            'tcpdump', '-i', 'any', 'tcp',
            'port',
        ] + port_params + [
            '-s', '20000',
            '-w', paths.get_logs_folder() + '/tcpdump.pcap',
        ],
        wait=False,
        log_prefix='sudo_tcpdump'
    )
    logging.info('tcpdump pid %s, return code %s', tcp_dump_proc.pid, tcp_dump_proc.returncode)
    return tcp_dump_proc


def stop_tcpdump(tcp_dump_proc):
    if tcp_dump_proc is None:
        return

    tcp_dump_proc.terminate()
    logging.info('tcpdump process terminated')
