import logging

from sandbox.sandboxsdk.channel import channel
from sandbox.sandboxsdk import parameters as sp

from sandbox.projects.common import apihelpers
from sandbox.projects.common import error_handlers as eh

_GROUP_NAME = 'Fresh Resources (SEARCH-2352)'


class QueryType(sp.SandboxStringParameter):
    name = 'query_type_for_optional_input'
    description = 'QueryType'
    required = False
    group = _GROUP_NAME


class TierName(sp.SandboxStringParameter):
    name = 'tier_for_optional_input'
    description = 'Tier name'
    required = False
    group = _GROUP_NAME


def set_optional_param(param):
    """
        Allows to set optional input params using TE attrs
        :param param: object of SandboxParameter class
    """
    if not channel.task.ctx.get(param.name):
        res_type = param.resource_type[0] if isinstance(param.resource_type, (list, tuple)) else param.resource_type
        logging.info("Try to set newest resource: %s", res_type)
        res = apihelpers.get_last_resource_with_attribute(
            resource_type=res_type,
            attribute_name="TE_web_base_prod_resources_{}".format(channel.task.ctx.get(TierName.name)),
        ) or apihelpers.get_last_resource_with_attribute(
            resource_type=res_type,
            # some resources (ex. models) are the same for all tiers
            attribute_name="TE_web_base_prod_resources_PlatinumTier0",
        )
        channel.task.ctx[param.name] = res.id


def set_interrelated_params(param1, attr1, param2, attr2):
    """
        Allows to set params with same attribute value.
        Especially useful for queries and databases.
        @param param1: 1st object of SandboxParameter class
        @param attr1: 1st attribute name
        @param param2: 2nd object of SandboxParameter class
        @param attr2: 2nd attribute name
    """
    if not channel.task.ctx.get(param1.name) and not channel.task.ctx.get(param2.name):
        res_type1 = param1.resource_type[0] if isinstance(param1.resource_type, (list, tuple)) else param1.resource_type
        res_type2 = param2.resource_type[0] if isinstance(param2.resource_type, (list, tuple)) else param2.resource_type
        res = get_last_interrelated_resources(res_type1, attr1, res_type2, attr2)
        channel.task.ctx[param1.name] = res[0].id
        channel.task.ctx[param2.name] = res[1].id


def get_last_interrelated_resources(res_type1, attr1, res_type2, attr2):
    logging.info("Try to get newest %s and %s", res_type1, res_type2)
    res_list1 = apihelpers.get_resources_with_attribute(res_type1, attribute_name=attr1, limit=20)
    res_list2 = apihelpers.get_resources_with_attribute(res_type2, attribute_name=attr2, limit=20)
    common_timestamps = (
        set([x.attributes.get(attr1) for x in res_list1]) &
        set([x.attributes.get(attr2) for x in res_list2])
    )
    eh.verify(len(common_timestamps) != 0, "Can't find common timestamp!")
    max_common_timestamp = max(common_timestamps)
    logging.info("Max common timestamp = %s", max_common_timestamp)
    result = []
    for r in res_list1:
        if r.attributes.get(attr1) == max_common_timestamp:
            result.append(r)
            break
    for r in res_list2:
        if r.attributes.get(attr2) == max_common_timestamp:
            result.append(r)
            break
    return result
