# coding: utf-8
"""
    Search-wide routines related to queries handling.

    Please obey PEP8 coding standards and Sandbox StyleGuide here
    https://wiki.yandex-team.ru/sandbox/codestyleguide

    New functions without documentation comments are FORBIDDEN.

    Maintainers: mvel@
"""

import sandbox.projects.websearch.middlesearch.resources as ms_resources
from sandbox.projects import resource_types
from sandbox.projects.common.search.response import cgi

QUERIES_RESOURCE_TYPES = (
    # generic type
    resource_types.PLAIN_TEXT_QUERIES,
    # metasearch types
    ms_resources.WebMiddlesearchPlainTextQueries,
    resource_types.IMAGES_MIDDLESEARCH_PLAIN_TEXT_REQUESTS,
    resource_types.VIDEO_MIDDLESEARCH_PLAIN_TEXT_REQUESTS,
)


def parse_cgi_params(s, unquote=True):
    """
        Forms dict with cgi keys and list of values.
        :param s: string, contained cgi
        :param unquote: optionally unquotes keys and vals
    """
    res = {}

    for key, value in cgi.split_to_cgi(s, unquote=unquote):
        res.setdefault(key, []).append(value)

    return res


def get_unique_queries(queries, unified_key):
    """
        :param queries: queries iterator
        :param unified_key: cgi param that shouldn't have repeated value
        Sorts by 'user_request' and removes repetitions.
    """
    unique_keys = set()
    for q in queries:
        curr_key = parse_cgi_params(q, unquote=False).get(unified_key, [''])[0]
        if curr_key not in unique_keys:
            unique_keys.add(curr_key)
            yield q
