# -*- coding: utf-8 -*-
import time
import urllib2

from sandbox.projects import resource_types
from sandbox.sandboxsdk.errors import SandboxTaskUnknownError
from sandbox.sandboxsdk.channel import channel
from sandbox.sandboxsdk.parameters import ResourceSelector
from sandbox.sandboxsdk.parameters import SandboxIntegerParameter


def create_params(queries_resource=resource_types.PLAIN_TEXT_QUERIES):
    group_name = 'Requester params'

    class Params:
        class Queries(ResourceSelector):
            name = 'queries_resource_id'
            description = 'Source queries'
            resource_type = queries_resource
            group = group_name
            required = True

        class QueriesLimit(SandboxIntegerParameter):
            name = 'queries_limit'
            description = 'Limit number of queries (0 = unlimited)'
            group = group_name
            default_value = 0

        params = (
            Queries,
            QueriesLimit,
        )

    return Params


_DEFAULT_PARAMS = create_params()


def get_avg_response_time(search_component, ctx):
    """
        используя ресурс с запросами из ctx опросить поисковый компонент,
        среднее время запроса (миллисекунд) добавить в ctx['avg_resp_time']
    """

    with open(channel.task.sync_resource(ctx[_DEFAULT_PARAMS.Queries.name])) as f:
        search_component.start()
        search_component.wait()
        avg_resp_time = search_component.use_component(
            lambda: get_url_avg_response_time(
                http_server="http://localhost:{}".format(search_component.port),
                url_path=search_component.http_collection,
                queries_fd=f,
                queries_limit=ctx[_DEFAULT_PARAMS.QueriesLimit.name],  # this parameter is required
            )
        )
        search_component.stop()

    return avg_resp_time


def get_url_avg_response_time(http_server, url_path, queries_fd, queries_limit):
    """
        :param http_server: 'http://server:port'
        :param url_path: url (используется в случае, если запросы начинаются с ?)
        :param queries_limit: количество запросов (0 - все запросы)
        :return: среднее время ответа на запросы в миллисекундах
    """
    u = None
    reqs_cnt = 0
    reqs_time = 0
    for line in queries_fd:
        if queries_limit > 0 and queries_limit == reqs_cnt:
            break

        query = line.rstrip()
        if query[0] == '?':
            requrl = '{}/{}{}'.format(http_server, url_path, query)
        else:
            requrl = '{}{}'.format(http_server, query)
        begin = time.time()
        try:
            u = urllib2.urlopen(requrl)
            u.read()
        finally:
            if u:
                u.close()
        end = time.time()
        if end > begin:
            reqs_time += end - begin
        reqs_cnt += 1
    if reqs_cnt == 0:
        raise SandboxTaskUnknownError(
            "Queries list is empty. "
            "Please check your input parameters or plan resources. "
        )
    return 1000. * reqs_time / reqs_cnt
