import argparse
import json


def dump_data(data_path, token, path_to_table):
    import yt.wrapper as yt

    yt_client = yt.YtClient(proxy="banach", token=token)
    table_path = yt.TablePath(name=path_to_table, append=True)
    with open(data_path) as data:
        yt_client.write_table(
            table_path, [json.load(data)],
            format=yt.JsonFormat(attributes={"encode_utf8": False})
        )


def main():
    pars = argparse.ArgumentParser(description="Dump blender perf data to YT")
    pars.add_argument("--data", "-d", help="Data as path json")
    pars.add_argument("--token", "-t", help="Token")
    pars.add_argument("--table", "-T", help="Path to YT table [banach]")
    opts = pars.parse_args()
    dump_data(opts.data, opts.token, opts.table)


if __name__ == '__main__':
    main()
