from sandbox import sdk2
from sandbox.common.types import client as ctc


class TinyRequirements(sdk2.Requirements):
    """
    Default (reasonably slow) requirements for simple tasks.

    Please DO NOT CHANGE them. If you need customized params,
    it's better to inherit these settings and override necessary parameters.
    """

    disk_space = 128  # 128 Mb (small but reasonable default)
    cores = 1  # very important requirement for multislots!
    ram = 512  # 512 Mb
    client_tags = (ctc.Tag.MULTISLOT | ctc.Tag.GENERIC)

    # disable all caches by default (make it multislot-aware)
    class Caches(sdk2.Requirements.Caches):
        pass


class BuildRequirements(sdk2.Requirements):
    """
    Please DO NOT CHANGE them. If you need customized params,
    it's better to inherit these settings and override necessary parameters.
    """

    disk_space = 64000  # 64 Gb (reasonable default)
    cores = 16  # very important requirement for multislots!
    ram = 63 * 1024  # to fit in 64 Gb box

    # disable all caches by default (make it multislot-aware)
    class Caches(sdk2.Requirements.Caches):
        pass


class BuildLinuxRequirements(BuildRequirements):
    client_tags = (ctc.Tag.MULTISLOT | ctc.Tag.GENERIC) & ctc.Tag.Group.LINUX
