import json


class ResourceMeta(object):
    """
        A class to pass meta info from tasklets to tasklet executor, which in turns
        creates an actual resources
    """

    def __init__(self, name, path, resource_type, attrs):
        self.name = name
        self.path = path
        self.resource_type = resource_type
        self.attributes = attrs

    def dump(self):
        return {
            "name": self.name,
            "path": self.path,
            "resource_type": self.resource_type,
            "attributes": self.attributes,
        }

    @classmethod
    def load(cls, info):
        return cls(info["name"], info["path"], info["resource_type"], info["attributes"])


def encode_resources(resources):
    return json.dumps([r.dump() for r in resources])


def decode_resources(data):
    return [ResourceMeta.load(info) for info in json.loads(data)]
