# -*- coding: utf-8 -*-

import logging
import os.path

from sandbox import common


def get_html_template(file_name):
    path = os.path.join(os.path.dirname(__file__), file_name)
    if common.system.inside_the_binary():
        from library.python import resource
        resource_data = resource.find(path)
        if resource_data is not None:
            logging.debug("Arcadia resource %r loaded", path)
            return resource_data
    with open(path, 'r') as f:
        html_string = f.read()
    return html_string
