# -*- coding: utf-8 -*-

"""
    Time limiting manager

    Usage, examples:
    http://stackoverflow.com/questions/366682/how-to-limit-execution-time-of-a-function-call-in-python
"""

import signal
import logging

from contextlib import contextmanager


class TimeoutException(Exception):
    pass


@contextmanager
def time_limit(seconds):

    def signal_handler(signum, frame):
        logging.info("Timeout signal handler called")
        raise TimeoutException()

    signal.signal(signal.SIGALRM, signal_handler)
    signal.alarm(seconds)
    logging.info("Set timeout handler for %s seconds", seconds)
    try:
        yield
    finally:
        signal.alarm(0)
