from threading import Lock


class ExceptionManager(object):
    def __init__(self):
        self.exceptions = []
        self.lock = Lock()

    def store_exception(self, exception):
        self.lock.acquire()
        self.exceptions.append(exception)
        self.lock.release()

    def run_target(self, target, *args):
        try:
            target(*args)
        except Exception as e:
            self.store_exception(e)

    def check_exceptions(self):
        if self.exceptions:
            raise self.exceptions.pop(0)
