# coding: utf-8


class HtmlTable:
    def __init__(self, header=None):
        self.header = header if header else ''
        self.post_header = ''
        self.text = []
        self.head = []
        self.data_format = []
        self.data = []
        self.__curline = []

    def add_value(self, v, col='', cls=''):
        self.__curline.append({'value': v, 'color': col, 'class': cls})

    def add_line(self, line, col='', cls=''):
        if line:
            self.br()
            for l in line:
                self.__curline.append({'value': l, 'color': col, 'class': cls})
            self.br()

    def br(self):
        if self.__curline:
            self.data.append(self.__curline)
            self.__curline = []

    def render(self, justify=True, use_color=False):
        self.br()
        res = []
        if self.header:
            res.append('<h3>%s</h3>\n' % self.header)
        if self.post_header:
            res.append('<h4>%s</h4>\n' % self.post_header)
        if self.text:
            res.append('<p>%s</p>\n' % '<br/>'.join(self.text))
        if self.head or self.data:
            res.append('<table class="main">')
            if self.head:
                res.append('<tr>%s</tr>\n' % ''.join('<th>%s</th>' % h for h in self.head))
            if self.data:
                ml = max([len(a) for a in self.data])
                for dd in self.data:
                    if justify and len(dd) < ml:
                        dd.extend([{'value': ''} for x in range(1, ml - len(dd))])
                    res.append('<tr>')
                    for i, d in enumerate(dd):
                        attrs = ''
                        if use_color and 'color' in d and d['color']:
                            attrs += ' color="%s"' % d['color']
                        if 'class' in d and d['class']:
                            attrs += ' class="%s"' % d['class']
                        val = d['value']
                        if i < len(self.data_format):
                            try:
                                val = self.data_format[i] % val
                            except:
                                pass
                        else:
                            if type(val) == float:
                                val = '%.2f' % val
                        res.append('<td%s>%s</td>' % (attrs, val))
                    res.append('</tr>\n')
            res.append('</table>\n')

        return ''.join(res).encode('utf-8')
