import threading
import urllib2
import time
import logging


class Shooter(threading.Thread):
    def __init__(self, host, requests, id=0, atemps=10, save_answers=False, ignore_failures=True, with_newlines=False):
        threading.Thread.__init__(self)
        self.host = host
        self.requests = requests
        self.atemps = atemps
        self.id = id
        self.save_answers = save_answers
        self.ignore_failures = ignore_failures
        self.answers = []
        self.with_newlines = with_newlines

    def run(self):
        log_step = max(len(self.requests) / 100, 50)
        for num, request in enumerate(self.requests):
            for atempt in range(self.atemps):
                try:
                    if num % log_step == 0:
                        logging.info('thread %s: %s shoots done' % (self.id, num))
                    url = 'http://%s/%s' % (self.host, request[1:] if request.startswith('/') else request)
                    answer = urllib2.urlopen(url).read()
                    if self.save_answers:
                        if self.with_newlines:
                            self.answers.append(answer)
                        else:
                            self.answers.append(answer.replace('\n', ''))
                    break
                except Exception as e:
                    logging.info('atempt %i request #%i failed: %s' % (atempt, num, url))
                    logging.exception(e)
                    if atempt == self.atemps - 1:
                        msg = 'Cant send request: %s' % url
                        if self.ignore_failures:
                            self.answers.append(msg)
                        else:
                            raise Exception(msg)
                    time.sleep(1 + atempt)


class MiniGun(object):
    def __init__(self, host, requests, threads=10, save_answers=False, ignore_failures=True, attempts_per_req=10, with_newlines=False):
        self.host = host
        self.threads = threads
        self.requests = requests
        self.save_answers = save_answers
        self.ignore_failures = ignore_failures
        self.answers = []
        self.attempts_per_req = attempts_per_req
        self.with_newlines = with_newlines

    def shoot(self):
        requests_num = len(self.requests)
        requests_per_thread = requests_num / self.threads

        shooters = []
        for i in range(self.threads):
            new_shooter = Shooter(
                host=self.host,
                requests=self.requests[i * requests_per_thread:(i + 1) * requests_per_thread],
                id=i,
                save_answers=self.save_answers,
                ignore_failures=self.ignore_failures,
                atemps=self.attempts_per_req,
                with_newlines=self.with_newlines
            )
            shooters.append(new_shooter)

        for shooter in shooters:
            shooter.start()

        for shooter in shooters:
            shooter.join()
            if self.save_answers:
                self.answers += shooter.answers
