from sandbox import common
import sandbox.common.types.task as ctt

from sandbox.sandboxsdk import parameters as sp

import sandbox.projects.common.wizard.resources as wr
import sandbox.projects.websearch.begemot.resources as br
from sandbox.projects import resource_types

TARGET_CONFIG_TYPES = [
    wr.WizardLingboostConfig,
    resource_types.WIZARD_CONFIG,
    resource_types.WIZARD_CONFIG_NEW,
    resource_types.WIZARD_GEO_CONFIG_NEW,
    resource_types.WIZARD_ANTIROBOT_CONFIG_NEW,
    resource_types.WIZARD_REALTIME_CONFIG_NEW,
    resource_types.WIZARD_RSYA_CONFIG,
    resource_types.WIZARD_RSYA_CONFIG_NEW,
]


class WizardBuildParameter(sp.TaskSelector):
    required = True
    task_type = 'BUILD_WIZARD'  # projects.BuildWizard.BuildWizard.type


class WizardBuildOrRemoteParameter(sp.SandboxStringParameter):
    required = True


class WizardBuildOrSvnParameter(sp.SandboxStringParameter):
    required = True

    @classmethod
    def cast(cls, value):
        if str(value).startswith('svn+ssh://'):
            return sp.SandboxArcadiaUrlParameter.cast(value)
        return WizardBuildParameter.cast(int(value))


class WizardRuntimeParameter(WizardBuildParameter):
    task_type = 'WIZARD_RUNTIME_BUILD'  # projects.WizardRuntimeBuild.WizardRuntimeBuild.type
    required = True


class EntitySearchBuildParameter(sp.TaskSelector):
    required = True
    task_type = 'BUILD_ENTITYSEARCH'  # DELETED; projects.BuildEntitySearch.BuildEntitySearch.type

    @classmethod
    def get_custom_parameters(cls):
        status = '{},{},{}'.format(
            str(ctt.Status.Group.FINISH),
            str(ctt.Status.Group.EXECUTE),
            str(ctt.Status.Group.WAIT)
            )
        return {
            'type': ','.join(common.utils.chain(cls.task_type)),
            'status': status,
            'limit': 20,
        }

# New params for new priemka tests


class BuildCommon(sp.TaskSelector):
    task_type = ["BUILD_WIZARD_2"]
    group = "Build tasks"

    @classmethod
    def get_custom_parameters(cls):
        result = super(BuildCommon, cls).get_custom_parameters()
        result.update({'show_childs': True})
        return result


class BuildTaskNew(BuildCommon):
    required = True
    name = "build_task_new"
    description = 'Build task new'


class BuildTaskOld(BuildCommon):
    """
        Not required param! In case of not specified - get current production binary
    """
    name = "build_task_old"
    description = 'Build task old (if not specified - use production)'

# --------------------


class Binary(sp.ResourceSelector):
    name = 'wizard_binary'
    description = 'Wizard binary'
    resource_type = resource_types.REMOTE_WIZARD
    required = True


class Config(sp.ResourceSelector):
    name = 'wizard_config'
    description = 'Wizard config'
    resource_type = resource_types.WIZARD_CONFIG
    required = True


class PrintWizardConfig(sp.ResourceSelector):
    name = 'printwizard_config'
    description = 'Printwizard config'
    resource_type = resource_types.PRINTWZRD_CONFIG
    required = True


class Shard(sp.ResourceSelector):
    name = 'wizard_shard'
    description = 'Wizard shard'
    resource_type = resource_types.WIZARD_SHARD
    required = True


class Plan(sp.ResourceSelector):
    name = "wizard_plan"
    description = "Wizard plan"
    resource_type = [resource_types.BASESEARCH_PLAN, resource_types.REMOTE_WIZARD_PLAN, br.BEGEMOT_APP_HOST_PLAN]
    required = True


class Queries(sp.ResourceSelector):
    name = 'wizard_queries'
    description = 'Wizard queries'
    resource_type = [
        resource_types.PLAIN_TEXT_QUERIES,
        resource_types.IMAGES_MIDDLESEARCH_PLAIN_TEXT_REQUESTS,
        resource_types.VIDEO_MIDDLESEARCH_PLAIN_TEXT_REQUESTS,
        wr.WizardQueries
    ]
    required = True


class ExtraQueryParams(sp.SandboxStringParameter):
    name = 'wizard_query_params'
    description = 'Additional URL-encoded query parameters'
    required = False


class RuntimeData(sp.ResourceSelector):
    name = 'runtime_data'
    description = 'Runtime data'
    resource_type = resource_types.WIZARD_RUNTIME_PACKAGE
    required = False


class CacheEnable(sp.SandboxBoolParameter):
    name = 'enable_wizard_cache'
    description = 'Enable wizard cache'
    default_value = False


class UseAppHost(sp.SandboxBoolParameter):
    name = 'use_app_host'
    description = 'Route requests through apphost'
    default_value = False


class BuildForGeosearch(sp.SandboxBoolParameter):
    name = 'build_geosearch'
    description = 'Build wizard for Geosearch'
    default_value = False


class WizardReducer(sp.ResourceSelector):
    name = 'wizard_reducer'
    description = 'Wizard reducer'
    resource_type = resource_types.WIZARDYT


WIZ_PERF_PARAMS = (
    Binary,
    Config,
    Shard,
    Plan,
    RuntimeData,
    CacheEnable,
    UseAppHost,
)
