try:
    from urllib.parse import quote, parse_qs
except ImportError:
    from urllib import quote
    from urlparse import parse_qs


def parse_query(req, extra_params={}, maybe_full=True):
    '''Given a line of a printwzrd request list, construct an HTTP path + query.'''
    req, _, rules = req.partition('$print:')
    req, s, param = req.partition('$cgi:')
    if not s:
        rules, _, param = rules.partition('$cgi:')

    rules = rules.strip().split(',') if rules.strip() else []
    param = param.strip()
    p = dict(extra_params)
    if maybe_full and not rules and not param:
        splitted_req = req.split('&')
        full_req = ''
        is_full_req = True
        for item in splitted_req:
            kv = item.split('=', 1)
            if len(kv) < 2:
                is_full_req = False
                break
            else:
                full_req = '&'.join([full_req, "{}={}".format(kv[0], kv[1])])
        full_req = full_req.replace('+$cgi%3A', '&').strip('&')
    else:
        is_full_req = False
    p['wizextra'] = list(p.get('wizextra', []))
    if 'dbgwzr' not in p:
        p['dbgwzr'] = ['2']
    if not is_full_req:
        p['text'] = p['user_request'] = [req]
    if param:
        p.update(parse_qs(param.strip('&').replace(';', '%3B')))
    if rules:
        p['rwr'] = [','.join('on:' + r for r in rules)]
    p['format'] = ['json']
    # disable thesaurus inner cache for stable results
    p['nocache'] = ['da']
    str_to_add = (full_req + '&').replace(';', '%3B') if is_full_req else ''
    return (
        '/wizard?' + str_to_add + '&'.join('{}={}'.format(quote(k), quote(v)) for k in sorted(p) for v in p[k]),
        rules
    )

def read_wizard_requests(file_name):
    """Read a printwzrd-style request list (whitespace-only lines are ignored, `^@.+` are comments)."""
    with open(file_name) as f:
        for line in f:
            line = line.strip('\n\r')
            if line and not line.startswith('@'):
                yield line
