import urllib
import xml.etree.ElementTree as ElementTree

import tests_base

MetricsUrl = "metrics.yandex-team.ru"
MetricsUser = "sereglond"


class MetricsProvider(tests_base.TestsProvider):
    class MetricsTest(tests_base.TestBase):
        def __init__(self, line, config=None, prefix=None):
            tests_base.TestBase.__init__(self, prefix=prefix if prefix else "metrics", config=config)

            line = line.split()
            assert (len(line) == 3)

            self._Name = line[0]

            self.Results = map(float, line[1:])

        def __Diff(self):
            results = self.Results
            max_result = max(results)

            if not max_result:
                return 0

            return abs(float(results[0]) - results[1]) / max_result

        def IsOK(self):
            if self.Ignore():
                return True

            limits = self._Config.get("limits", {})
            limit = limits.get(self._Name)
            if not limit:
                limit = limits.get(None)

            return limit is None or self.__Diff() < limit

        def Error(self):
            return "Bad metric {}: {} ({})".format(self.Name(), ", ".join(map(str, self.Results)), self.__Diff())

    Name = "metrics"

    def __init__(self, type, **args):
        tests_base.TestsProvider.__init__(self, **args)

        assert type
        self.__Type = type

        self.Name = "{}:{}".format(self.Name, self.__Type)

    @classmethod
    def Generate(cls, config, **args):
        return [cls(config=config, type=t, **args) for t in config.get(cls.Name, {}).get("types", [])]

    def _RunTest(self, beta):
        url = (
            "http://{}/import/serp?store-mode=URLS&host={}&type={}"
            "&passesCount=1000&timeout=10000000&custom-param={}&user={}&xml"
        ).format(
            MetricsUrl, beta.Host, self.__Type,
            urllib.quote("{}&{}".format(self._Config.get("params", ""), beta.Cgi)), MetricsUser
        )

        xml = tests_base.url_open_strict(url)
        serp = ElementTree.fromstring(xml).find("serp")
        return serp.get("serpset-id")

    def _StopTest(self, id):
        url = "http://{}/import/serp?action=delete&serpset-id={}&download-id=0".format(MetricsUrl, id)

        tests_base.url_open(url)

    def _IsOver(self, id):
        url = "http://{}/import/serp?serpset-id={}&xml&user={}".format(MetricsUrl, id, MetricsUser)

        xml = tests_base.url_open(url)

        res = ElementTree.fromstring(xml).find("importer")
        if res is None:
            return False

        return res.get("isFinished") == "true"

    def _Compare(self, id0, id1):
        url = "http://{}/compare/serps/tab/format?serpset-id={}&serpset-id={}".format(MetricsUrl, id0, id1)

        data = tests_base.url_open(url)

        return data

    def _ParseDiff(self, diff):
        res = []
        for line in diff.split("\n")[1:]:
            line = line.strip()
            if not line:
                continue

            metric = self.MetricsTest(line, config=self._Config, prefix=self.Name)

            res.append(metric)

        return res

    def _DiffInfo(self, id0, id1):
        return "http://{}/compare/serps/by/metrics?serpset-id={}&serpset-id={}".format(MetricsUrl, id0, id1)
