import six
import urllib2
import xml.etree.ElementTree as ElementTree

import tests_base

# Svarog API: http://wiki.yandex-team.ru/EvgenijjKroxalev/autotesting/wizardapi


def CreateElement(tagname, content=None, parent=None, **attributes):
    node = ElementTree.Element(tagname) if parent is None else ElementTree.SubElement(parent, tagname)
    if content:
        node.text = content
    node.attrib.update((attr, six.text_type(value)) for attr, value in attributes.iteritems())

    return node


def Communicate(requestType, **jobArgs):
    request = CreateElement("request", type=requestType)
    CreateElement("job", parent=request, **jobArgs)

    message = ElementTree.tostring(request, encoding="utf-8")

    res = urllib2.urlopen("http://mokosh.yandex.ru/mondyn/cgi-bin/service.py", message).read()

    return res


def _GetJob(xml):
    res = ElementTree.fromstring(xml).find("job")
    if res is None:
        raise Exception("can't get job")
    return res


def GetJobId(xml):
    return _GetJob(xml).get("id")


class SvarogProvider(tests_base.TestsProvider):
    class SvarogTest(tests_base.TestBase):
        def __init__(self, names, xml, config=None):
            tests_base.TestBase.__init__(self, prefix="svarog", config=config)

            self._Name = xml.get("name")
            self.Bad = xml.get("bad") == "true"
            self.Barrier = float(xml.get("barrier"))
            self.Diff = {}

            i = 0
            for diff in xml.getiterator("diffvalue"):
                self.Diff[names[i]] = float(diff.get("value"))
                i += 1

        def IsOK(self):
            if self.Ignore():
                return True

            return not self.Bad

        def Error(self):
            return "Bad factor %s" % self.Name()

    Name = "svarog"

    def __init__(self, **args):
        tests_base.TestsProvider.__init__(self, **args)

    def _RunTest(self, beta):
        return GetJobId(Communicate(
            "start",
            type="lighttest",
            replicidx="middle:hamster.yandex.ru",  # production
            querycnt="500",
            poolflt="ru",
            # skip_factors = "307", # exclude video factor
            upper_host=beta.Host,
            aux_cgi=beta.Cgi,
        ))

    def _StopTestImpl(self, test):
        Communicate("drop", id=test)

    def _IsOver(self, id):
        state = _GetJob(Communicate("status", id=id)).get("state")
        if state == "ERROR":
            raise Exception("svarog error for %s" % id)
        return state == "SUCCESS"

    def _Compare(self, id0, id1):
        job = GetJobId(Communicate("start", type="difftest", poolflt="ru", baseline_id=id0, test_id=id1))

        self._WaitTest(job)

        url = _GetJob(Communicate("status", id=job)).get("result")

        status = urllib2.urlopen(url).read()

        return status

    def _ParseDiff(self, diff):
        xml = ElementTree.fromstring(diff)

        pools = []
        for pool in xml.getiterator("pool"):
            pools.append(pool.get("name"))

        res = []
        for el in xml.getiterator("factor"):
            res.append(self.SvarogTest(names=pools, xml=el, config=self._Config))

        return res

    def InternalErrors(self, test):
        id = test.get(self.Name)
        if not id:
            return []

        reqs_xml = Communicate("get-resource", id=id, resource="wizardings")

        reqs = ElementTree.fromstring(reqs_xml).findtext("job-resource")
        if not reqs:
            return ["can't get wizardings"]

        failures = reqs.count("wizard_failed=1")
        if failures:
            return ["wizard failures: %s/%s" % (failures, reqs.count("\n"))]

        return []
