import logging

from sandbox.sandboxsdk.svn import Arcadia


class SvnWizard(object):

    def __init__(self, branch):
        self._branch = Arcadia.replace(branch, path=Arcadia.parse_url(branch).path.partition("/arcadia")[0])

    def branch(self, ignore_revision=False):
        if ignore_revision:
            return self._add_path_to_branch("", ignore_revision)
        return self._branch

    def _add_path_to_branch(self, add_path, ignore_revision=False):
        parsed_url = Arcadia.parse_url(self._branch)
        revision = parsed_url.revision
        if ignore_revision:
            revision = ''
        return Arcadia.replace(self._branch, path=parsed_url.path + add_path, revision=revision)

    def arcadia(self, ignore_revision=False):
        return self._add_path_to_branch('/arcadia', ignore_revision)

    def arcadia_tests_data(self, ignore_revision=False):
        return self._add_path_to_branch('/arcadia_tests_data', ignore_revision)

    def wizard_data(self):
        return self._add_path_to_branch('/arcadia_tests_data/wizard')

    def wizard_runtime(self):
        return self._add_path_to_branch('/arcadia_tests_data/wizard.runtime')

    def entitysearch_data(self):
        return self._add_path_to_branch('/arcadia/search/wizard/entitysearch/data/shard_data')

    def entitysearch_data_db(self):
        return self._add_path_to_branch('/arcadia_tests_data/wizard/entity_search/shard/.db')

    def __eq__(self, other):
        parsed_url1 = Arcadia.parse_url(self.branch())
        parsed_url2 = Arcadia.parse_url(other.branch())
        logging.info('comparing %s and %s', parsed_url1, parsed_url2)
        result = parsed_url1.path == parsed_url2.path
        logging.info('result: %s', result)
        return result
