import logging

from sandbox.sandboxsdk.process import run_process

from sandbox.projects.common.utils import wait_searcher_start


class WizardRunner:
    def __init__(self, wizard_path, arcadia_tests_data_path, config_path, fresh_data_path=None, port=8891):
        self.wizard_path = wizard_path
        self.arcadia_tests_data_path = arcadia_tests_data_path
        self.config_path = config_path
        self.fresh_data_path = fresh_data_path
        self.proc = None
        self.port = port

    def start(self, wait=True):
        logging.info("starting wizard")
        cmd = [
            self.wizard_path,
            "-a", self.arcadia_tests_data_path,
            "-s", self.config_path,
            "-p", self.port
        ]
        if self.fresh_data_path:
            cmd += ["-r", self.fresh_data_path]

        self.proc = run_process(cmd, shell=True, wait=False, log_prefix='wizard')
        if wait:
            self.wait()

    def stop(self):
        logging.info("stoping wizard")
        if self.proc:
            self.proc.kill()
            self.proc = None

    def wait(self):
        logging.info('===waiting for wizard to start')
        wait_searcher_start('localhost', self.port, subproc_list=[self.proc])
        logging.info("===started")

    def __enter__(self):
        self.start()
        return self

    def __exit__(self, type, value, traceback):
        self.stop()
