import re
import logging
from collections import defaultdict
# Log format:
# 127.0.0.1 - - [2016-03-09T16:27:07.725539Z] "GET /turl/29?ref-page=132169 HTTP/1.1" 200 3092 "-" "-" "-,-" "-" "-" 1457540827.725539 "0" 590 - - 6687 - - - - -

CODE_REGEXP = re.compile(r'^(?:(?:[^"\s]+|".*?")\s+){5}(\d+)')


def get_code_counts(log_filename):
    code_counts = defaultdict(int)
    with open(log_filename) as log:
        for line in log:
            if 'Start cache daemon' in line:
                # Skipping start message for obsolete cachedaemons
                continue
            m = CODE_REGEXP.match(line)
            if m is None:
                logging.warning("Malformed line in %s:\n%s", log_filename, line)
                code_counts['UNKNOWN'] += 1
            else:
                code_counts[m.group(1)] += 1
    return code_counts


if __name__ == '__main__':
    import sys
    print(dict(get_code_counts(sys.argv[1])))
