import logging
import subprocess
import argparse
import os
import time

from sandbox.projects.common.yabs.cachedaemon import CacheDaemonStubStandalone
from sandbox.sandboxsdk.paths import make_folder


def main():

    logging.basicConfig(level=logging.DEBUG)
    parser = argparse.ArgumentParser()
    parser.add_argument("-c", "--cached", type=int)
    parser.add_argument("-d", "--dump", type=int)
    parser.add_argument("-a", "--auto-instance-types", action="store_true")

    args = parser.parse_args()

    stub = None

    def _sync_resource_stub(res_id):
        res_path = os.path.abspath(str(res_id))
        make_folder(res_path)
        subprocess.check_call(['sky', 'get', '-u', 'sbr:{}'.format(res_id)], cwd=res_path)
        return os.path.join(res_path, os.listdir(res_path)[0])

    def _create_resource_stub(*args, **kwargs):
        logging.info("Resource to be created:\n%s\n%s", args, kwargs)

    try:
        stub = CacheDaemonStubStandalone(
            _sync_resource_stub,
            instance_types=(None if args.auto_instance_types else ['bigb', 'turl', 'yacofast']),
            dump_res_id=args.dump,
            cache_daemon_res_id=args.cached,
            data_dir='cache_daemon_data'
        )
        logging.info("Cachedaemons started, ports: %s", stub.get_provided_services())
        time.sleep(3600)
    finally:
        try:
            if stub is not None:
                stub.check_access_log()
                logging.info("Access log OK")
                stub.stop_and_store_dump_impl(_create_resource_stub, {})
        except Exception:
            logging.exception("Failed to stop cachedaemons")


if __name__ == '__main__':
    main()
