# -*- coding: utf-8 -*-

import time
from sandbox import common
import os
from sandbox.projects.common.yabs.executers import run_sh


TMP_ERROR_RE = r'(404\s+Not Found|E: Some index files failed to download.|Temporary failure resolving|Size mismatch|Connection timed out|No route to host|Network is unreachable)'

DIST_SEARCH_STABLE = [
    'deb http://dist.yandex.ru/search stable/all/',
    'deb http://dist.yandex.ru/search stable/amd64/',

]
DIST_YANDEX_STABLE = [
    'deb http://dist.yandex.ru/yandex stable/all/',
]
DIST_SYSTEM_CONFIGS = [
    'deb http://dist.yandex.ru/system configs/all/',
]
DIST_PRECISE_STABLE = [
    'deb http://dist.yandex.ru/yandex-precise stable/amd64/',
]
BSDIST_PRECISE_STABLE = [
    'deb http://bsdist.yandex.net/yabs-precise stable/all/',
    'deb http://bsdist.yandex.net/yabs-precise stable/amd64/',
]
BSDIST_PRECISE_UNSTABLE = [
    'deb http://bsdist.yandex.net/yabs-precise unstable/all/',
    'deb http://bsdist.yandex.net/yabs-precise unstable/amd64/',
    'deb http://bsdist.yandex.net/qabs-bamboo-precise unstable/all/',
    'deb http://bsdist.yandex.net/qabs-bamboo-precise unstable/amd64/',
]
BSDIST_PRECISE_TESTING = [
    'deb http://bsdist.yandex.net/yabs-precise testing/all/',
    'deb http://bsdist.yandex.net/yabs-precise testing/amd64/',
    'deb http://bsdist.yandex.net/qabs-bamboo-precise testing/all/',
    'deb http://bsdist.yandex.net/qabs-bamboo-precise testing/amd64/',
]
BSDIST_PRECISE_PRESTABLE = [
    'deb http://bsdist.yandex.net/yabs-precise prestable/all/',
    'deb http://bsdist.yandex.net/yabs-precise prestable/amd64/',
]


YABS_DEB_DEPENDS = [
    'yabs-mysql-conf', 'yabs-dbrestore', 'yabs-mkdb',
    'config-monitoring-mysql-yabs',
    'liblog4perl-yabs-simple-perl',
    'libmysqlclient15off',
    'libmysqlclient18',
    'libpoolcontroller-perl',
    'libyandex-iptools-perl',
    'mysql-client-5.5',
    'mysql-client-core-5.5',
    'mysql-common',
    'mysql-server-5.5',
    'mysql-server-core-5.5',
    'python-mysqldb',
    'storage-packer',
    'yabs-base-modules',
    'yabs-basic',
    'yabs-conf',
    'yabs-coro-funcs',
    'yabs-global-info',
    'yabs-graphite-sender',
    'yabs-home',
    'yabs-host-util',
    'yabs-hosts-ping',
    'yabs-iptools',
    'yabs-libsys-sigaction-perl',
    'yabs-manage-physical-path',
    'yabs-memcached-conf',
    'yabs-mysql-conf-5.5',
    'yabs-mysql-conf-yabs-jemalloc-remover',
    'yabs-mysql-grants',
    'yabs-perl-conf',
    'yabs-perl-logger',
    'yabs-pool-controller',
    'yabs-python-base',
    'yabs-python-distutils',
    'yabs-python-logger',
    'yabs-python-modules',
    'yabs-python-sysutils',
    'yabs-rsync-conf',
    'yabs-rsync-data',
    'yabs-runit',
    'yabs-scriptcontrol',
    'yabs-servant-api',
    'yabs-stopwatch',
    'yabs-storage-perl-api',
    'yabs-system',
    'yabs-timeouts',
    'yabs-very-basic',
    'yandex-surf-features-arcadia',
    'clemmer',
    'config-monitoring-mysql',
    'config-monitoring-mysql-yabs',
    'libalgorithm-diff-perl',
    'libanti-deadlock-perl',
    'libany-moose-perl',
    'libb-hooks-endofscope-perl',
    'libb-hooks-op-check-perl',
    'libbit-vector-perl',
    'libbsd-resource-perl',
    'libcache-memcached-fast-perl',
    'libcarp-clan-perl',
    'libclass-load-perl',
    'libclass-singleton-perl',
    'libclone-perl',
    'libconfig-any-perl',
    'libcoro-mysql-perl',
    'libcoro-perl',
    'libdata-alias-perl',
    'libdata-compare-perl',
    'libdata-dumper-simple-perl',
    'libdata-optlist-perl',
    'libdata-validate-ip-perl',
    'libdate-calc-perl',
    'libdatetime-locale-perl',
    'libdatetime-perl',
    'libdatetime-timezone-perl',
    'libdbd-mysql-perl',
    'libdbi-perl',
    'libdevel-declare-perl',
    'libev-dev',
    'libev-perl',
    'libev4',
    'libexporter-renaming-perl',
    'libfile-find-rule-perl',
    'libfile-slurp-perl',
    'libfilesys-statvfs-perl',
    'libguard-perl',
    'libio-captureoutput-perl',
    'libio-socket-ip-perl',
    'libipc-system-simple-perl',
    'libjemalloc1',
    'libjson-xs-perl',
    'liblist-allutils-perl',
    'liblist-moreutils-perl',
    'liblog-dispatch-perl',
    'liblog-log4perl-perl',
    'liblog4perl-yabs-simple-perl',
    'liblzo2-2',
    'libmailtools-perl',
    'libmath-round-perl',
    'libmethod-signatures-perl',
    'libmodule-find-perl',
    'libmodule-runtime-perl',
    'libmouse-perl',
    'libmysqlclient15off',
    'libmysqlclient18',
    'libnet-daemon-perl',
    'libnet-ipv6addr-perl',
    'libnetwork-ipv4addr-perl',
    'libnumber-compare-perl',
    'libpackage-deprecationmanager-perl',
    'libpackage-stash-perl',
    'libparams-util-perl',
    'libparams-validate-perl',
    'libplrpc-perl',
    'libpoolcontroller-perl',
    'libppi-perl',
    'libprotobuf7',
    'libreadonly-perl',
    'libreadonly-xs-perl',
    'libsocket-getaddrinfo-perl',
    'libsub-exporter-perl',
    'libsub-install-perl',
    'libtask-weaken-perl',
    'libterm-readkey-perl',
    'libtext-diff-perl',
    'libtext-glob-perl',
    'libtry-tiny-perl',
    'libvariable-magic-perl',
    'libyaml-libyaml-perl',
    'libyaml-perl',
    'libyandex-iptools-perl',
    'memcached',
    'mysql-client-5.5',
    'mysql-client-core-5.5',
    'mysql-common',
    'mysql-server-5.5',
    'mysql-server-core-5.5',
    'perl-timeouts-xs',
    'process-watchdog',
    'python-gevent',
    'python-mysqldb',
    'python-psutil',
    'ssh',
    'storage-packer',
    'timelimit',
    'yabs-base-modules',
    'yabs-basic',
    'yabs-conf',
    'yabs-coro-funcs',
    'yabs-dbrestore',
    'yabs-global-info',
    'yabs-host-util',
    'yabs-hosts-ping',
    'yabs-iptools',
    'yabs-libsys-sigaction-perl',
    'yabs-manage-physical-path',
    'yabs-memcached-conf',
    'yabs-mkdb',
    'yabs-mysql-conf',
    'yabs-mysql-conf-5.5',
    'yabs-mysql-conf-yabs-jemalloc-remover',
    'yabs-mysql-grants',
    'yabs-perl-logger',
    'yabs-pool-controller',
    'yabs-python-base',
    'yabs-python-distutils',
    'yabs-python-logger',
    'yabs-python-modules',
    'yabs-python-sysutils',
    'yabs-rsync-conf',
    'yabs-rsync-data',
    'yabs-runit',
    'yabs-scriptcontrol',
    'yabs-servant-api',
    'yabs-stopwatch',
    'yabs-system',
    'yabs-timeouts',
    'yabs-very-basic',
    'yandex-hamster-check-mysql',
    'yandex-surf-features-arcadia',
]

_indexes_updated = 0


def get_pkg_ver(pkg_name):
    pkg_ver = ''
    if pkg_name:
        pkg_ver = run_sh(["dpkg-query -W -f='${Version}'", pkg_name])
    return pkg_ver.strip()


def _apt(cmd, params=[], check_exit_code=True):
    if isinstance(params, (list, tuple)):
        params = ' '.join(params)

    if len(params) != 0 or cmd in ['update', 'autoremove']:
        apt_cmd = "env DEBIAN_FRONTEND=noninteractive ASSUME_YES=1\
                   apt-get -q0 --assume-yes --force-yes\
                           -o Acquire::ForceIPv6=true\
                           -o Dpkg::Options::='--force-confdef'\
                           {} {}".format(cmd, params)
        run_sh(apt_cmd, check_exit_code=check_exit_code, tmp_error_re=TMP_ERROR_RE)
    else:
        raise common.errors.TaskError(
            "Can't exec apt {} cmd with empty params".format(cmd)
        )


def _update_indexes():
    """
    resynchronize the package index files
    """
    _apt('update')
    global _indexes_updated
    _indexes_updated = 1


def _set_repos(repos_list):
    if isinstance(repos_list, (list, tuple)):
        repos_list = "\n".join(map(str, repos_list))
    with open('sb-apt-src.list', 'w') as f:
        f.write(repos_list)
    run_sh('mv sb-apt-src.list /etc/apt/sources.list.d/')

    with open('sb-apt-pref', 'w') as f:
        for origin in ['dist.yandex.ru', 'bsdist.yandex.net']:
            for release, pri in [
                ('stable', 500),
                ('testing', 490),
                ('unstable', 480)
            ]:
                f.write((
                    "Package: *\nPin: origin \"{origin}\"\n"
                    "Pin: release a={release}\nPin-Priority: {priority}\n\n").format(
                        origin=origin,
                        release=release,
                        priority=pri
                        ))
    run_sh('mv sb-apt-pref /etc/apt/preferences.d/')
    _update_indexes()


def _clean_repos():
    run_sh('rm -rf /etc/apt/sources.list.d/sb-apt-src.list /etc/apt/preferences.d/sb-apt-pref')
    _update_indexes()


def install_pkg(pkgs_list, repos_list=[], use_yabs_deps_solver=True, clean_repos=True):
    """
    install input packages
    """
    # Always disable yandex-gosky updates from inside of the container
    if not os.path.exists('/var/run/gosky.nocron'):
        run_sh(['>', '/var/run/gosky.nocron'])

    if isinstance(pkgs_list, (str, unicode)):
        pkgs_list = pkgs_list.split()

    if repos_list:
        _set_repos(repos_list)
    elif not _indexes_updated:
        _update_indexes()
    time.sleep(10)

    if use_yabs_deps_solver:
        _apt('install', 'yabs-deps-solver')
        pkgs_list = run_sh(['yabs-deps-solver'] + pkgs_list).strip()

    _apt('install', pkgs_list)

    if repos_list and clean_repos:
        _clean_repos()


def remove_pkg(pkgs_list, check_exit_code=True):
    """
    remove input packages
    """
    if isinstance(pkgs_list, (str, unicode)):
        pkgs_list = pkgs_list.split()
    if pkgs_list:
        _apt(
            'autoremove --purge',
            "`dpkg -l | grep -E ' (" + "|".join(pkgs_list) + ") ' | awk '{print $2}'`",
            False
        )
        _apt(
            'autoremove --purge',
            "`dpkg -l | grep -iE '^([rp]|.[ncufh])\s' | awk '{print $2}'`",
            check_exit_code
        )
