# -*- coding: utf-8 -*-
import os

from executers import run_sh


def move_to_task_dir(src_files=[], dst_path='tmp', owner=None):
    for src in src_files:
        dst = os.path.abspath(dst_path+'/'+src)

        if os.path.islink(src) and os.path.exists(src):
            continue
        elif os.path.exists(src):
            dst_dir = os.path.dirname(dst)
            if not os.path.exists(dst_dir):
                os.makedirs(dst_dir)
            run_sh(['mv', '-f', src, dst_dir])
        elif not os.path.exists(dst):
            os.makedirs(dst)
            run_sh(['chmod', '777', dst])

        if owner:
            run_sh(['chown', owner, dst])

        run_sh(['ln', '-sT', dst, src])
