#!/usr/bin/env python
# -*- coding: utf-8 -*-

try:
    from . import config_utils as utils
except ValueError:
    # For local runs to validate
    import config_utils as utils


YAV_SECRET_ID = "sec-01cxsyy14q7g750shsxj6vs0zk"
COMMON_LB_CLIENT = 'bs-lbyt-reader'

LB_REQUEST_TIMEOUT = 10  # seconds

YT_REQUEST_TIMEOUT = 5  # seconds
YT_HEAVY_REQUEST_TIMEOUT = 15  # seconds
YT_REQUEST_RETRIES = 3

LOCKER_TRANSACTION_TIMEOUT = 30  # seconds
WAIT_LOCK_TIMEOUT = 3600  # seconds (wait for previous task to end)
NO_LOCK_SLEEP = 4  # seconds (wait if lock is gone and relock attempt is failed)
MAX_LOCK_FAILURES = 4

PARTITIONS_OVERLAP = 3  # to calculate max offsets per partition from max_offsets_per_task
LB_MERGE_GAP_COEFFICIENT = 1.5  # to calculate max gap before considering LB as straggled

RECENT_ERRORS_INTERVAL = 120  # minutes
KEEP_INPUT_TABLES = 3  # hours

DEFAULT_TASK_FREQUENCY = utils.DEFAULT_TASK_FREQUENCY
DEFAULT_KEEP_COMPLETED_TASKS = utils.DEFAULT_KEEP_COMPLETED_TASKS
DEFAULT_MAX_SMOOTHING_SLEEP = utils.DEFAULT_MAX_SMOOTHING_SLEEP
DEFAULT_TIMEOUT_COEFFICIENT = utils.DEFAULT_TIMEOUT_COEFFICIENT

LOGTYPES = {
    # "lb_name" by default is equal to name
    # "max_offsets_per_task" is required
    # "max_offsets_per_pqclient" by default is unlimited
    # "frequency" is in seconds, by default is DEFAULT_TASK_FREQUENCY (see above)
    # "data_format" by default is tskv
    # See https://wiki.yandex-team.ru/bannernajakrutilka/sbyt/lbyt/#params for recommendations on choosing values
    'bs-abuse-log': {
        'max_offsets_per_task': 11000,
    },
    'bs-chevent-log': {
        'max_offsets_per_task': 150000,
        'max_offsets_per_pqclient': 80,
    },
    'bs-undochevent-log': {
        'ident': 'bsexport',
        'max_offsets_per_task': 200,
    },
    'bs-event-log': {
        'max_offsets_per_task': 800000,
        'frequency': 60,
    },
    'bs-eventbad-log': {
        'max_offsets_per_task': 120000,
        'frequency': 210,
    },
    'bs-hit-log': {
        'max_offsets_per_task': 1100000,
        'frequency': 140,
    },
    'bs-chtracking-log': {
        'max_offsets_per_task': 5000,
        'max_offsets_per_pqclient': 100,
        'frequency': 145,
    },
    'bs-undochtracking-log': {
        'ident': 'bsexport',
        'max_offsets_per_task': 200,
    },
    'bs-performance-log': {
        'max_offsets_per_task': 400000,
        'max_offsets_per_pqclient': 3000,
        'frequency': 170,
    },
    'bs-match-log': {
        'max_offsets_per_task': 1000000,
        'max_offsets_per_pqclient': 1000,
        'frequency': 170,
    },
    'bs-ssp-response-log': {
        'max_offsets_per_task': 140000,
    },
    'bs-dsp-checked-log': {
        'lb_name': 'bs-dsp-checked-log',
        'max_offsets_per_task': 25000,
        'max_offsets_per_pqclient': 30,
        'frequency': 125,
    },
    'bs-dsp-bad-log': {
        'max_offsets_per_task': 2500000,
        'max_offsets_per_pqclient': 3000,
        'frequency': 220,
    },
    'bs-undodsp-log': {
        'ident': 'bsint',
        'max_offsets_per_task': 800,
        'max_offsets_per_pqclient': 50,
    },
    'bs-rtb-log': {
        'max_offsets_per_task': 500000,
        'frequency': 200,
    },
    'bs-ssp-log': {
        'max_offsets_per_task': 150000,
    },
    'bs-newsevent-log': {
        'max_offsets_per_task': 120000,
    },
    'metrika-mobile-install-log': {
        'max_offsets_per_task': 3000,
    },
    'metrika-mobile-install-private-log': {
        'max_offsets_per_task': 5000,
    },
    'bs-postback-log': {
        'max_offsets_per_task': 20000,
    },
    'bs-qtail-log': {
        'max_offsets_per_task': 60000,
        'frequency': 177,
    },
    'bs-ally-services-billed-checked-log': {
        'lb_name': 'bs-ally-services-billed-checked-log',
        'max_offsets_per_task': 150000,
        'max_offsets_per_pqclient': 1500,
        'frequency': 350,
        'data_format': 'json',
    },
    'bs-action-checked-log': {
        'lb_name': 'bs-action-checked-log',
        'max_offsets_per_task': 150000,
        'max_offsets_per_pqclient': 1500,
        'frequency': 350,
        'data_format': 'json',
    },
    'zen-billed-log': {
        'lb_name': 'zen-billed-log',
        'ident': 'zen',
        'max_offsets_per_task': 150000,
        'max_offsets_per_pqclient': 1500,
        'frequency': 350,
        'data_format': 'json'
    },

    # Testing

    'bs-undochevent-prestable-log': {
        'lb_name': 'bs-undochevent-log',
        'ident': 'yabs-sb@testing@bsexport',
        'max_offsets_per_task': 200,
    },
    'bs-undodsp-prestable-log': {
        'lb_name': 'bs-undodsp-log',
        'ident': 'yabs-sb@testing@bsint',
        'max_offsets_per_task': 400,
        'max_offsets_per_pqclient': 50,
    },
    'bs-undochtracking-prestable-log': {
        'lb_name': 'bs-undochtracking-log',
        'ident': 'yabs-sb@testing@bsexport',
        'max_offsets_per_task': 200,
    },

    # For the Xurma
    'xurma-event-log': {
        'lb_name': 'bs-event-log',
        'max_offsets_per_task': 650000,
        'max_offsets_per_pqclient': 4000,
        'frequency': 60,
    },
    'xurma-chevent-log': {
        'ident': 'bsexport',
        'lb_name': 'bs-chevent-log',
        'max_offsets_per_task': 80000,
        'frequency': 120,
    },
    'xurma-dsp-log': {
        'lb_name': 'bs-dsp-log',
        'max_offsets_per_task': 660000,
        'max_offsets_per_pqclient': 750,
        'frequency': 120,
    },
    'xurma-bs-tracking-log': {
        'lb_name': 'bs-tracking-log',
        'max_offsets_per_task': 100000,
        'frequency': 120,
    },
    'xurma-undo-event-log': {
        'ident': 'bsexport',
        'lb_name': 'bs-undochevent-log',
        'max_offsets_per_task': 45,
        'frequency': 60,
    },
    'xurma-bs-action-log': {
        'lb_name': 'bs-action-log',
        'max_offsets_per_task': 30,
        'frequency': 60,
        'data_format': 'json',
    },
    'xurma-bs-ally-services-billed-log': {
        'lb_name': 'bs-ally-services-billed-log',
        'max_offsets_per_task': 10,
        'frequency': 60,
        'data_format': 'json',
    },
    'xurma-direct-ppc-cmd-log': {
        'lb_name': 'direct-ppclog-cmd-log',
        'ident': 'direct',
        'max_offsets_per_task': 50000,
        'frequency': 300,
        'data_format': 'ppcjson',
    },
    'zen-events-log': {
        'max_offsets_per_task': 250000,
        'frequency': 180,
        'data_format': 'json',
    },
    'ugc-db-update-log': {
        'ident': 'ugc-db',
        'max_offsets_per_task': 22000,
        'frequency': 300,
        'data_format': 'json',
    },
    'answ-user-activity-log': {
        'max_offsets_per_task': 3000,
        'frequency': 300,
        'data_format': 'json',
    },
    'xurma-clean-web-events-log': {
        'lb_name': 'events',
        'ident': 'clean_web@prod',
        'max_offsets_per_task': 125000,
        'frequency': 300,
        'data_format': 'json',
    },
    'xurma-district-user-activity-log': {
        'lb_name': 'user-activity-log',
        'ident': 'district@prod',
        'max_offsets_per_task': 20000,
        'frequency': 300,
        'data_format': 'json',
    },
}

MANAGER_JOBS = {
    # "use_time_binding" by default is false
    # All other fields are required
    # "dest_path" is relative to common prefix (from task parameter)
    # "logtypes", "lb" and "yt" accept either single string or iterable (tuple, list, set)

    # 'example-chevent-somecluster': {
    #     'dest_path': '/yabs-lbyt-reader/done',
    #     'logtypes': 'bs-chevent-log',
    #     'lb': 'bs-test',
    #     'yt': 'somecluster',
    # }
}

READER_JOBS = {
    # "job" by default is equal to name
    # "only_for_quorum" by default is false
    # "lb" and "yt" by default are from manager job (there must be only one than, not list)
    # "keep_completed_tasks" is in hours, by default is DEFAULT_KEEP_COMPLETED_TASKS (see above)
    # "max_smoothing_sleep" is in seconds, by default is DEFAULT_MAX_SMOOTHING_SLEEP (see above)
    # "timeout_coefficient" by default is DEFAULT_TIMEOUT_COEFFICIENT (see above)
    # "pool", "pool_tree", "file_storage", "stats_path" are empty strings by default
    # "tmp_input_table_attributes" is empty dict by default
    # "yt_log_level" is empty by default
    # All other fields are required if "only_for_quorum" is false, are ignored otherwise
    # "stats_path" may be either absolute or relative to common prefix (from task parameter)
    # "quota" is in megabytes, default is 1 GB

    # 'example-chevent-somecluster': {
    #     'client': 'ytstat-somecluster',
    #     'max_simultaneous_downloads': 2,
    #     'keep_sequential': False,
    #     'quota': 175*1024,
    #     'count': 15,
    # },
}


# Autoconfigurations for Xurma jobs


XURMA_ISOLATED_MAPPING = {'bohr': 'lbkx', 'landau': 'lbkx', 'markov': None}
XURMA_MIXED_MAPPING = {'bohr': 'sas', 'landau': 'vla', 'markov': None}
XURMA_POOL_TREES = {
    'bohr': None,
    'landau': None,
    'arnold': 'xurma',
    'hahn': 'xurma'
}


def xurma_job(*args, **kwargs):
    utils.add_xurma_jobs(MANAGER_JOBS, READER_JOBS, *args, **kwargs)


xurma_job(
    'afraudita/answ-user-activity', 'answ-user-activity-log', XURMA_MIXED_MAPPING,
    yt_pool_params=utils.make_yt_pool_params(XURMA_POOL_TREES, use_isolated_pool='afraudita'),
)
xurma_job(
    'afraudita/ugc', 'ugc-db-update-log', XURMA_MIXED_MAPPING,
    yt_pool_params=utils.make_yt_pool_params(XURMA_POOL_TREES, use_isolated_pool='afraudita'),
)
xurma_job(
    'afraudita/clean-web', 'xurma-clean-web-events-log', XURMA_MIXED_MAPPING,
    yt_pool_params=utils.make_yt_pool_params(XURMA_POOL_TREES, use_isolated_pool='afraudita'),
    quota=8 * 1024,
)

xurma_job(
    'bs', 'xurma-event-log', XURMA_ISOLATED_MAPPING,
    yt_pool_params=utils.make_yt_pool_params(XURMA_POOL_TREES, use_isolated_pool='bs'),
    use_fat_keys=True,
    quota=500*1024,
    count=25,
    max_simultaneous_downloads=2,
)
MANAGER_JOBS['xurma-bs-prod']['use_time_binding'] = True

xurma_job(
    'dsp', 'xurma-dsp-log', XURMA_MIXED_MAPPING,
    use_fat_keys=True,
    quota=600*1024,
    count=20,
    keep_completed_tasks=84,
    yt_pool_params=utils.make_yt_pool_params(
        XURMA_POOL_TREES, use_isolated_pool='dsp',
    ),
    max_simultaneous_downloads=3,
)

xurma_job(
    'btr', 'xurma-bs-tracking-log', XURMA_MIXED_MAPPING,
    yt_pool_params=utils.make_yt_pool_params(XURMA_POOL_TREES, use_isolated_pool='btr'),
    quota=100*1024,
)
xurma_job(
    'btr/chevent', 'xurma-chevent-log', XURMA_ISOLATED_MAPPING,
    yt_pool_params=utils.make_yt_pool_params(XURMA_POOL_TREES, use_isolated_pool='btr'),
    use_unimportant_client=True,
    quota=10*1024,
)

xurma_job(
    'prebilling/undo', 'xurma-undo-event-log', XURMA_ISOLATED_MAPPING,
    yt_pool_params=utils.make_yt_pool_params(XURMA_POOL_TREES, use_isolated_pool='prebilling'),
    use_unimportant_client=True,
    quota=50*1024,
    count=25,
)
xurma_job(
    'prebilling/action', 'xurma-bs-action-log', XURMA_ISOLATED_MAPPING,
    yt_pool_params=utils.make_yt_pool_params(XURMA_POOL_TREES, use_isolated_pool='prebilling'),
    use_unimportant_client=True,
    quota=50*1024,
    count=25,
)
xurma_job(
    'prebilling/allyservicesbilled', 'xurma-bs-ally-services-billed-log', XURMA_ISOLATED_MAPPING,
    yt_pool_params=utils.make_yt_pool_params(XURMA_POOL_TREES, use_isolated_pool='prebilling'),
    use_unimportant_client=True,
    quota=50*1024,
    count=25,
)

xurma_job(
    'zen/events', 'zen-events-log', XURMA_ISOLATED_MAPPING,
    yt_pool_params=utils.make_yt_pool_params(XURMA_POOL_TREES, use_isolated_pool='zen'),
    use_unimportant_client=True,
    use_fat_keys=True,
    quota=500*1024,
    err_expiration_time=24,
)


# Autoconfigurations for BS Statistic jobs


def stat_job(*args, **kwargs):
    utils.add_stat_jobs(MANAGER_JOBS, READER_JOBS, *args, **kwargs)


stat_job('abuse', 'hahn', 'sas', count=100)
stat_job('abuse', 'freud', 'sas', count=100)
stat_job('abuse', 'arnold', 'vla', count=100, client_account='ytstat@')  # On Arnold our clients belong to a separate account

stat_job('chevent', 'zeno', 'bs-test', max_dl=3, quota=450*1024, count=30)
stat_job('chevent', 'freud', 'bs-prod', max_dl=3, quota=5242880, count=300)
stat_job('chevent', 'hahn', 'bs-prod', max_dl=3, quota=40*1024*1024, count=1600)
stat_job('chevent', 'arnold', 'bs-prod', max_dl=4, quota=10*1024*1024, count=600, client_account='ytstat@')
stat_job('chevent', 'seneca-sas', 'bs-prod', max_dl=3, quota=1500*1024, count=100)
stat_job('chevent', 'seneca-vla', 'bs-prod', max_dl=3, quota=1500*1024, count=100, client_account='ytstat@')

stat_job('zen-billed', 'freud', 'bs-prod', quota=5242880, count=300, bs_log=False)
stat_job('zen-billed', 'hahn', 'bs-prod', quota=5242880, count=700, bs_log=False)
stat_job('zen-billed', 'arnold', 'bs-prod', quota=5242880, count=700, bs_log=False, client_account='ytstat@')

stat_job('ally-services-billed-checked', 'freud', 'bs-prod', quota=5242880, count=300)
stat_job('ally-services-billed-checked', 'hahn', 'bs-prod', quota=5242880, count=700)
stat_job('ally-services-billed-checked', 'arnold', 'bs-prod', quota=5242880, count=700, client_account='ytstat@')

stat_job('action-checked', 'freud', 'bs-prod', quota=5242880, count=300)
stat_job('action-checked', 'hahn', 'bs-prod', quota=5242880, count=700)
stat_job('action-checked', 'arnold', 'bs-prod', quota=5242880, count=700, client_account='ytstat@')

stat_job('undochevent', 'zeno', 'bs-test', quota=250*1024)
stat_job('undochevent', 'freud', 'bs-prod', quota=2500*1024, count=100)
stat_job('undochevent', 'seneca-sas', 'bs-prod', quota=1500*1024, count=100)
stat_job('undochevent', 'seneca-vla', 'bs-prod', quota=1500*1024, count=100, client_account='ytstat@')
stat_job('undochevent', 'hahn', 'bs-prod', max_dl=4, quota=2500*1024, count=100)
stat_job('undochevent', 'arnold', 'bs-prod', max_dl=4, quota=2500*1024, count=100, client_account='ytstat@')

stat_job('event', 'freud', 'sas', max_dl=4, quota=5242880, count=300, keep_completed_tasks=48)
stat_job('event', 'hahn', 'sas', max_dl=8, quota=1048576, count=600, keep_completed_tasks=72)
stat_job('event', 'arnold', 'vla', max_dl=4, quota=5242880, count=600, keep_completed_tasks=72, client_account='ytstat@')
stat_job('event', 'seneca-sas', 'sas', max_dl=3, quota=250*1024, keep_completed_tasks=72)
stat_job('event', 'seneca-vla', 'vla', max_dl=3, quota=250*1024, keep_completed_tasks=72, client_account='ytstat@')

stat_job('eventbad', 'freud', 'sas', count=100, quota=40*1024)
stat_job('eventbad', 'hahn', 'sas', count=100, quota=40*1024)
stat_job('eventbad', 'arnold', 'vla', count=100, quota=40*1024, client_account='ytstat@')
stat_job('eventbad', 'zeno', 'vla', count=100, quota=40*1024)
stat_job('eventbad', 'seneca-sas', 'sas', count=100, quota=40*1024)
stat_job('eventbad', 'seneca-vla', 'vla', count=100, quota=40*1024, client_account='ytstat@')

stat_job('hit', 'zeno', 'vla', max_dl=3, quota=1800*1024, count=30, keep_completed_tasks=48)
stat_job('hit', 'freud', 'sas', max_dl=3, quota=6000*1024, count=100, keep_completed_tasks=48)
stat_job('hit', 'hahn', 'sas', max_dl=6, quota=40*1024*1024, count=300, keep_completed_tasks=72, yt_log_level='debug')
stat_job('hit', 'arnold', 'vla', max_dl=6, quota=40*1024*1024, count=300, keep_completed_tasks=72, client_account='ytstat@')
stat_job('hit', 'seneca-sas', 'sas', max_dl=4, count=60, quota=2500*1024, keep_completed_tasks=72)
stat_job('hit', 'seneca-vla', 'vla', max_dl=4, count=60, quota=2500*1024, keep_completed_tasks=72, client_account='ytstat@')

stat_job('chtracking', 'freud', 'bs-prod', quota=400*1024, count=140)
stat_job('chtracking', 'hahn', 'bs-prod', quota=400*1024, count=140)
stat_job('chtracking', 'arnold', 'bs-prod', quota=400*1024, count=140, client_account='ytstat@')

stat_job('undochtracking', 'freud', 'bs-prod', quota=2500*1024, count=100)
stat_job('undochtracking', 'hahn', 'bs-prod', quota=2500*1024, count=100)
stat_job('undochtracking', 'arnold', 'bs-prod', quota=2500*1024, count=100, client_account='ytstat@')

stat_job('dsp-checked', 'freud',  'bs-prod',  quota=1800*1024, count=300)
stat_job('dsp-checked', 'hahn',   'bs-prod', quota=3600*1024, count=600)
stat_job('dsp-checked', 'arnold', 'bs-prod', max_dl=4, quota=3600*1024, count=600, client_account='ytstat@')
stat_job('dsp-checked', 'zeno',       'bs-prod', quota=1800*1024,  count=300)
stat_job('dsp-checked', 'seneca-sas', 'bs-prod', quota=3600*1024, count=600)
stat_job('dsp-checked', 'seneca-vla', 'bs-prod', quota=3600*1024, count=600, client_account='ytstat@')

stat_job('performance', 'freud', 'sas', max_dl=6, count=60, quota=250*1024)
stat_job('performance', 'hahn', 'sas', max_dl=6, count=100, quota=900*1024)
stat_job('performance', 'arnold', 'vla', max_dl=6, count=100, quota=900*1024, client_account='ytstat@')

stat_job('dsp-bad', 'zeno', 'vla', quota=300*1024)
stat_job('dsp-bad', 'seneca-sas', 'sas', count=200, quota=8000*1024, max_dl=4)
stat_job('dsp-bad', 'seneca-vla', 'vla', count=200, quota=8000*1024, client_account='ytstat@')

stat_job('undodsp', 'zeno', 'bs-prod', quota=300*1024, count=100)
stat_job('undodsp', 'freud', 'bs-prod', quota=300*1024, count=100)
stat_job('undodsp', 'seneca-sas', 'bs-prod', quota=300*1024, count=100)
stat_job('undodsp', 'seneca-vla', 'bs-prod', quota=300*1024, count=100, client_account='ytstat@')
stat_job('undodsp', 'hahn', 'bs-prod', quota=300*1024, count=100)
stat_job('undodsp', 'arnold', 'bs-prod', quota=300*1024, count=100, client_account='ytstat@')

stat_job('ssp-response', 'freud', 'sas', count=50, quota=450*1024)
stat_job('ssp-response', 'hahn', 'sas', count=50, max_dl=3, quota=450*1024)
stat_job('ssp-response', 'arnold', 'vla', count=50, max_dl=3, quota=450*1024, client_account='ytstat@')

stat_job('metrika-mobile-install', 'freud', 'sas', count=50, bs_log=False)
stat_job('metrika-mobile-install', 'hahn', 'sas', count=100, bs_log=False)
stat_job('metrika-mobile-install', 'arnold', 'vla', count=100, bs_log=False, client_account='ytstat@')

stat_job('metrika-mobile-install-private', 'freud', 'sas', count=50, bs_log=False)
stat_job('metrika-mobile-install-private', 'hahn', 'sas', count=100, bs_log=False)
stat_job('metrika-mobile-install-private', 'arnold', 'vla', count=100, bs_log=False, client_account='ytstat@')

stat_job('postback', 'freud', 'sas', quota=100*1024, count=100, max_dl=4)
stat_job('postback', 'hahn', 'sas', quota=100*1024, count=100, max_dl=4)
stat_job('postback', 'arnold', 'vla', quota=100*1024, count=100, max_dl=4, client_account='ytstat@')

stat_job('rtb', 'zeno', 'vla', quota=2400*1024, keep_completed_tasks=48)
stat_job('rtb', 'seneca-sas', 'sas', quota=2400*1024, keep_completed_tasks=72)
stat_job('rtb', 'seneca-vla', 'vla', quota=2400*1024, keep_completed_tasks=72, client_account='ytstat@')

stat_job('ssp', 'zeno', 'vla', quota=10*1024)
stat_job('ssp', 'freud', 'sas', count=30, quota=12*1024)
stat_job('ssp', 'seneca-sas', 'sas', quota=6*1024)
stat_job('ssp', 'seneca-vla', 'vla', quota=6*1024, client_account='ytstat@')
stat_job('ssp', 'hahn', 'sas', count=100, quota=50*1024)
stat_job('ssp', 'arnold', 'vla', count=100, quota=50*1024, client_account='ytstat@')

stat_job('newsevent', 'freud', 'sas', quota=3*1024)
stat_job('newsevent', 'hahn', 'sas', count=100, quota=300*1024)
stat_job('newsevent', 'arnold', 'vla', count=100, quota=300*1024, client_account='ytstat@')

stat_job('match', 'freud', 'sas', count=30, quota=500*1024, max_dl=3)
stat_job('match', 'hahn', 'sas', count=50, quota=1000*1024,  max_dl=3)
stat_job('match', 'arnold', 'vla', count=50, quota=1000*1024, client_account='ytstat@', max_dl=3)

stat_job('qtail', 'hahn', 'sas', count=300, quota=100*1024)
stat_job('qtail', 'arnold', 'vla', count=300,  quota=100*1024, client_account='ytstat@')
stat_job('qtail', 'freud', 'sas', count=150, quota=50*1024)

stat_job('undochevent-prestable', 'freud', 'bs-prod', quota=2500*1024, count=100)
stat_job('undochevent-prestable', 'hahn', 'bs-prod', quota=2500*1024, count=100)
stat_job('undochevent-prestable', 'arnold', 'bs-prod', quota=2500*1024, count=100, client_account='ytstat@')

stat_job('undodsp-prestable', 'freud', 'bs-prod', quota=3*1024)
stat_job('undodsp-prestable', 'hahn', 'bs-prod', quota=3*1024)
stat_job('undodsp-prestable', 'arnold', 'bs-prod', quota=3*1024, client_account='ytstat@')

stat_job('undochtracking-prestable', 'hahn', 'bs-prod', quota=2500*1024, count=100)
stat_job('undochtracking-prestable', 'freud', 'bs-prod', quota=2500*1024, count=100)

# Prepare and validate on import
utils.prepare_and_validate_config(LOGTYPES, MANAGER_JOBS, READER_JOBS)
