# -*- coding: utf-8 -*-

from sandbox import sdk2
import sandbox.sandboxsdk.parameters as sbparams


class TasksToWait(sbparams.SandboxStringParameter):
    name = "tasks_to_wait"
    description = "Task ids to wait (divide by space)"
    default_value = ""


class AlsoInstall(sbparams.SandboxStringParameter):
    name = 'also_install'
    default_value = ''
    description = 'Extra pkgs to install'


class CollectorParameters(sdk2.Parameters):
    """ Base part of YABS statistics collector's input parameters, which are reused by coordinator task """
    yt_proxy = sdk2.parameters.String("yt_proxy", required=True)
    yt_token_secret_id = sdk2.parameters.YavSecret(
        label="YT token secret id",
        required=True,
        description='secret should contain keys: YT_TOKEN',
    )
    log_path = sdk2.parameters.String(
        "Node name (path) of logs. Example: //home/yabs/log/yabs-rt",
        default="//home/yabs/log/yabs-rt"
    )
    is_development = sdk2.parameters.Bool("is_development")
    is_auditable = sdk2.parameters.Bool("is_auditable")
    allow_man = sdk2.parameters.Bool("Allow collector execution in MAN")
    allow_vla = sdk2.parameters.Bool("Allow collector execution in VLA")
    lock_wait_time = sdk2.parameters.Integer("Time to wait for lock in collector tasks (in ms)", default=600000)
